% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/settdp.R
\name{setTDP}
\alias{setTDP}
\title{setTDP}
\usage{
setTDP(pvalue, featureIDs, data, set, alpha = 0.05)
}
\arguments{
\item{pvalue}{The vector of p-values. It can be the name of the covariate representing the Vector of
raw p-values in the \code{data} or a single vector but in the latter case it should match the
\code{featureIDs} vector}

\item{featureIDs}{The vector of feature IDs. It can be the name of the covariate representing the IDs in the
\code{data} or a single vector but in the latter case it should match the \code{pvalue} vector}

\item{data}{Optional data frame or matrix containing the variables in \code{pvalue} and \code{featureIDs}}

\item{set}{The selection of features defining the feature-set based on the the \code{featureIDs}.
If missing, the set of all features is evaluated}

\item{alpha}{The type I error allowed. The default is 0.05. NOTE: this shouls be consistent across the study}
}
\value{
A named vector including the lower bound and point estimate for the true discovery proportion (TDP)
of the specified test for the feature-set is returned.
}
\description{
Estimates the TDP of the specified set of features.
}
\examples{

\dontrun{
set.seed(159)
#generate random p-values with pseudo IDs
m<- 100
pvalues <- runif(m,0,1)^5
featureIDs <- as.character(1:m)

# perform a self-contained test for all features
settest(pvalues, featureIDs, testype = "selfcontained")

# estimate the proportion of true discoveries among all m features
settdp(pvalues, featureIDs)

# create a random pathway of size 60
randset=as.character(c(sample(1:m, 60)))


# estimate the proportion of true discoveries in a random set of size 50
settdp(pvalues, featureIDs, set=randset)

}

}
\references{
Mitra Ebrahimpoor, Pietro Spitali, Kristina Hettne, Roula Tsonaka, Jelle Goeman,
Simultaneous Enrichment Analysis of all Possible Gene-sets: Unifying Self-Contained
and Competitive Methods, Briefings in Bioinformatics, , bbz074, https://doi.org/10.1093/bib/bbz074
}
\seealso{
\code{\link{setTest}}, \code{\link{SEA}}
}
\author{
Mitra Ebrahimpoor

\email{m.ebrahimpoor@lumc.nl}
}
