% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/min_depth_interactions.R
\name{plot_predict_interaction}
\alias{plot_predict_interaction}
\title{Plot the prediction of the forest for a grid of values of two numerical variables}
\usage{
plot_predict_interaction(
  forest,
  data,
  variable1,
  variable2,
  grid = 100,
  main = paste0("Prediction of the forest for different values of ", paste0(variable1,
    paste0(" and ", variable2))),
  time = NULL
)
}
\arguments{
\item{forest}{A randomForest or ranger object}

\item{data}{The data frame on which forest was trained}

\item{variable1}{A character string with the name a numerical predictor that will on X-axis}

\item{variable2}{A character string with the name a numerical predictor that will on Y-axis}

\item{grid}{The number of points on the one-dimensional grid on x and y-axis}

\item{main}{A string to be used as title of the plot}

\item{time}{A numeric value specifying the time at which to predict survival probability, only
applies to survival forests. If not specified, the time closest to predicted median survival
time is used}
}
\value{
A ggplot2 object
}
\description{
Plot the prediction of the forest for a grid of values of two numerical variables
}
\examples{
forest <- randomForest::randomForest(Species ~., data = iris)
plot_predict_interaction(forest, iris, "Petal.Width", "Sepal.Width")
forest_ranger <- ranger::ranger(Species ~., data = iris)
plot_predict_interaction(forest, iris, "Petal.Width", "Sepal.Width")

}
