% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mtry_compare.R
\name{mtry_compare}
\alias{mtry_compare}
\title{Mtry Tune via VIPs}
\usage{
mtry_compare(
  formula,
  data = NULL,
  scale = FALSE,
  sqrt = TRUE,
  num_var,
  mvec,
  ...
)
}
\arguments{
\item{formula}{an object of class "\link{formula}" (or one that can be
coerced to that class): a symbolic description of the model to be fitted.}

\item{data}{an optional data frame containing the variables in the model.
By default the variables are taken from the environment which randomForest
is called from.}

\item{scale}{For permutation based measures such as MSE or Accuracy, should
the measures be divided by their "standard errors"? Default is False.}

\item{sqrt}{Boolean value indicating whether importance metrics should be
adjusted via a square root transformation. Default is True.}

\item{num_var}{Optional integer argument for reducing the number of
variables to the top 'num_var'. Should be an integer between 1 and the
total number of predictor variables in the model or it should be a
positive proportion of variables desired.}

\item{mvec}{Optional vector argument for defining choices of mtry to have the
function consider. Should be a vector of integers between 1 and the total
number of predictor variables in the model. Or it can be a vector of
proportions (strictly less than 1) of the number of predictor variables.}

\item{...}{Other parameters to pass to the randomForest function.}
}
\value{
A list of data.frames, useful plots, and forest objects for user
  evaluations of the randomForest hyperparameter mtry.
}
\description{
A list of data.frames and useful plots for user evaluations of
  the randomForest hyperparameter mtry.
}
\examples{
m <- mtry_compare(factor(Species) ~ ., data = iris, sqrt = TRUE)
m
}
