% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter-filtfilt.R
\name{filtfilt}
\alias{filtfilt}
\title{Forward and reverse filter a one-dimensional signal}
\usage{
filtfilt(b, a, x)
}
\arguments{
\item{b}{one-dimensional real numerical vector, the moving-average
coefficients of an \code{ARMA} filter}

\item{a}{the auto-regressive (recursive) coefficients of an \code{ARMA} filter}

\item{x}{numerical vector input (real value)}
}
\value{
The filtered signal, normally the same length as the input signal
\code{x}.
}
\description{
The result has been tested against 'Matlab' \code{filtfilt}
function. Currently this function only supports one filter at a time.
}
\examples{

t <- seq(0, 1, by = 0.01)
x <- sin(2 * pi * t * 2.3)
bf <- gsignal::butter(2, c(0.15, 0.3))

res <- filtfilt(bf$b, bf$a, x)

## Matlab (2022a) equivalent:
# t = [0:0.01:1];
# x = sin(2 * pi * t * 2.3);
# [b,a] = butter(2,[.15,.3]);
# res = filtfilt(b, a, x)

}
