% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform_mesh_functions.R
\name{scale_mesh}
\alias{scale_mesh}
\title{Scale Mesh}
\usage{
scale_mesh(mesh, scale = 1, center = c(0, 0, 0))
}
\arguments{
\item{mesh}{The mesh.}

\item{scale}{Default \code{c(1,1,1)}. The scale amount, per axis.}

\item{center}{Default \code{c(0,0,0)}. The center of the scale.}
}
\value{
Scaled mesh
}
\description{
Scale Mesh
}
\examples{
if(run_documentation()) {
#Scale a mesh in the Cornell box
robj = obj_mesh(r_obj(), scale=150,angle=c(0,180,0))

generate_cornell_mesh() |>
add_shape(scale_mesh(translate_mesh(robj,c(400,100,155)),0.5, center=c(400,100,155))) |>
add_shape(scale_mesh(translate_mesh(robj,c(555/2,200,555/2)),1.5, center=c(555/2,200,555/2))) |>
add_shape(scale_mesh(translate_mesh(robj,c(55,300,400)),c(0.5,2,0.5), center=c(155,300,400))) |>
rasterize_scene(light_info=directional_light(direction=c(0.1,0.6,-1)))
}
}
