% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/template.R
\name{template_dataset}
\alias{template_dataset}
\title{Access a Dataset for a Template}
\usage{
template_dataset(template, layer = NULL)
}
\arguments{
\item{template}{The template identifier or template object. This specifies the dataset to retrieve.}

\item{layer}{The layer of the dataset to access (e.g., "input" or "staging"). If \code{NULL}, the layer \verb{"input} is used.}
}
\value{
An Arrow dataset object representing the data for the specified template and layer.
}
\description{
This function provides access to a dataset associated with a specific template.
It retrieves the dataset stored in the database folder for the given template and layer,
using the schema defined in the template configuration.
}
\details{
The \code{template_dataset()} function is a generic function that dispatches to specific methods
based on the type of the \code{template} argument. It retrieves the dataset by resolving the template using
\code{template_retrieve()} if the input is a template identifier.
}
\examples{
\dontrun{
# Access the dataset for the "b3-reference-rates" template
ds <- template_dataset("b3-reference-rates")

# Access the dataset for the "b3-reference-rates" template in the staging layer
ds <- template_dataset("b3-reference-rates", layer = "staging")

# Query the dataset
ds |>
  dplyr::filter(refdate > as.Date("2023-01-01")) |>
  dplyr::collect()
}

}
