% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbin-quantile.R
\name{rbin_quantiles}
\alias{rbin_quantiles}
\alias{plot.rbin_quantiles}
\title{Quantile binning}
\usage{
rbin_quantiles(
  data = NULL,
  response = NULL,
  predictor = NULL,
  bins = 10,
  include_na = TRUE
)

\method{plot}{rbin_quantiles}(x, print_plot = TRUE, ...)
}
\arguments{
\item{data}{A \code{data.frame} or \code{tibble}.}

\item{response}{Response variable.}

\item{predictor}{Predictor variable.}

\item{bins}{Number of bins.}

\item{include_na}{logical; if \code{TRUE}, a separate bin is created for missing values.}

\item{x}{An object of class \code{rbin_quantiles}.}

\item{print_plot}{logical; if \code{TRUE}, prints the plot else returns a plot object.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A \code{tibble}.
}
\description{
Bin continuous data using quantiles.
}
\examples{
bins <- rbin_quantiles(mbank, y, age, 10)
bins

# plot
plot(bins)

}
