% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uniprot_proteomes.R
\name{rba_uniprot_proteomes_search}
\alias{rba_uniprot_proteomes_search}
\title{Search Proteomes in UniProt}
\usage{
rba_uniprot_proteomes_search(
  name = NULL,
  upid = NULL,
  taxid = NULL,
  keyword = NULL,
  xref = NULL,
  genome_acc = NULL,
  is_ref_proteome = NULL,
  is_redundant = NULL,
  ...
)
}
\arguments{
\item{name}{a keyword in proteome's name}

\item{upid}{\href{https://www.uniprot.org/help/proteome_id}{UniProt Proteome
identifier (UPID)}. You can supply up to 100 UPIDs.}

\item{taxid}{NIH-NCBI \href{https://www.uniprot.org/taxonomy/}{Taxon ID}.
You can supply up to 20 taxon IDs.}

\item{keyword}{Limit the search to entries that contain your supplied
keyword. see: \href{https://www.uniprot.org/keywords/}{UniProt Keywords}}

\item{xref}{Proteome cross-references such as Genome assembly ID or
Biosample ID. You can supply up to 20 cross-reference IDs.}

\item{genome_acc}{Genome accession associated with the proteome's components.}

\item{is_ref_proteome}{(logical) If TRUE, only return reference proteomes; If
FALSE, only returns non-reference proteomes; If NULL (default), the results
will not be filtered by this criteria see
\href{https://www.uniprot.org/help/reference_proteome}{'What are reference
proteomes?'} for more information.}

\item{is_redundant}{(logical) If TRUE, only return redundant proteomes; If
FALSE, only returns non-redundant proteomes; If NULL (default), the results
will not be filtered by redundancy. see
\href{https://www.uniprot.org/help/proteome_redundancy}{'Reducing proteome
redundancy'} for more information.}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
A list where each element is a list that corresponds to a single
  proteome (search hit) and contains informations pertinent to that proteome.
}
\description{
UniProt collects and annotates proteomes (Protein sets expressed in an
  organism). Using this function you can search UniProt for available
  proteomes. see \href{https://www.uniprot.org/help/proteome}{What are
  proteomes?} for more information. You may also
  refine your search with modifiers such as keyword, taxon id etc. See
  "Arguments section" for more information.
}
\details{
Note that this is a search function. Thus, you are not required to fill
  every argument; You may use whatever combinations of arguments you see
  fit for your query.
}
\section{Corresponding API Resources}{

 "GET https://ebi.ac.uk/proteins/api/proteomes"
}

\examples{
\donttest{
rba_uniprot_proteomes_search(name = "SARS-CoV")
}
\donttest{
rba_uniprot_proteomes_search(name = "SARS-CoV", is_ref_proteome = TRUE)
}
\donttest{
rba_uniprot_proteomes_search(name = "SARS-CoV", is_ref_proteome = TRUE)
}
\donttest{
rba_uniprot_proteomes_search(genome_acc = "AY274119")
}

}
\references{
\itemize{
  \item The UniProt Consortium , UniProt: the Universal Protein
  Knowledgebase in 2025, Nucleic Acids Research, 2024;, gkae1010,
  https://doi.org/10.1093/nar/gkae1010
  \item Andrew Nightingale, Ricardo Antunes, Emanuele Alpi, Borisas
  Bursteinas, Leonardo Gonzales, Wudong Liu, Jie Luo, Guoying Qi, Edd
  Turner, Maria Martin, The Proteins API: accessing key integrated protein
  and genome information, Nucleic Acids Research, Volume 45, Issue W1,
  3 July 2017, Pages W539–W544, https://doi.org/10.1093/nar/gkx237
  \item \href{https://www.ebi.ac.uk/proteins/api/doc/}{Proteins API
  Documentation}
  \item \href{https://www.uniprot.org/help/publications}{Citations note
  on UniProt website}
  }
}
\seealso{
Other "UniProt - Proteomes": 
\code{\link{rba_uniprot_genecentric}()},
\code{\link{rba_uniprot_genecentric_search}()},
\code{\link{rba_uniprot_proteomes}()}
}
\concept{"UniProt - Proteomes"}
