% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jaspar.R
\name{rba_jaspar_taxons}
\alias{rba_jaspar_taxons}
\title{List available taxonomic groups in JASPAR}
\usage{
rba_jaspar_taxons(release = 2024, ...)
}
\arguments{
\item{release}{Numeric: (default = 2024) Which JASPAR database release
to use? Available options are: 2024, 2022, 2020, 2018, 2016, and 2014.}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
A data frame with information of available species.
}
\description{
JASPAR organizes matrix profiles from multiple species
  in six taxonomic groups. Use this function to retrieve a list of
  available taxonomic groups in a JASPAR database release.
}
\section{Corresponding API Resources}{

 "GET https://jaspar.elixir.no/api/v1/taxon/"
}

\examples{
\donttest{
rba_jaspar_taxons(release = 2024)
}

}
\references{
\itemize{
  \item Rauluseviciute I, Riudavets-Puig R, Blanc-Mathieu R,
  Castro-Mondragon JA, Ferenc K, Kumar V, Lemma RB, Lucas J, Chèneby J,
  Baranasic D, Khan A, Fornes O, Gundersen S, Johansen M, Hovig E, Lenhard
  B, Sandelin A, Wasserman WW, Parcy F, Mathelier A JASPAR 2024:
  20th anniversary of the open-access database of transcription factor
  binding profiles Nucleic Acids Res. in_press; doi: 10.1093/nar/gkad1059
  \item Khan, A. and Mathelier, A. JASPAR RESTful API: accessing JASPAR data
  from any programming language. Bioinformatics, 2017,
  doi: 10.1093/bioinformatics/btx804
  \item
  \href{https://jaspar.elixir.no/api/v1/docs/}{JASPAR API Documentation}
  \item \href{https://jaspar.elixir.no/faq/}{Citations note
  on JASPAR website}
  }
}
\seealso{
Other "JASPAR": 
\code{\link{rba_jaspar_collections}()},
\code{\link{rba_jaspar_collections_matrices}()},
\code{\link{rba_jaspar_matrix}()},
\code{\link{rba_jaspar_matrix_search}()},
\code{\link{rba_jaspar_matrix_versions}()},
\code{\link{rba_jaspar_releases}()},
\code{\link{rba_jaspar_sites}()},
\code{\link{rba_jaspar_species}()},
\code{\link{rba_jaspar_species_matrices}()},
\code{\link{rba_jaspar_taxons_matrices}()},
\code{\link{rba_jaspar_tffm}()},
\code{\link{rba_jaspar_tffm_search}()}
}
\concept{"JASPAR"}
