% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_table_from.R
\name{get_table_from}
\alias{get_table_from}
\title{Extracts a single table from a CLDF dataset.}
\usage{
get_table_from(
  table,
  mdpath,
  cache_dir = tools::R_user_dir("rcldf", which = "cache")
)
}
\arguments{
\item{table}{a CLDF table type}

\item{mdpath}{a path to a CLDF file}

\item{cache_dir}{a directory to cache downloaded files to}
}
\value{
a dataframe
}
\description{
Extracts a single table from a CLDF dataset.
}
\examples{
md_json <- system.file("extdata/huon", "cldf-metadata.json", package = "rcldf")
df <- get_table_from("LanguageTable", md_json)
}
