% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{re2_which}
\alias{re2_which}
\alias{re2_subset}
\title{Select strings that match, or find their positions}
\usage{
re2_which(string, pattern)

re2_subset(string, pattern)
}
\arguments{
\item{string}{A character vector, or an object which can be coerced to one.}

\item{pattern}{Character string containing a regular expression,
 or a pre-compiled regular expression (or a vector of character
 strings and pre-compiled regular expressions). \cr
See \code{\link{re2_regexp}} for available options. \cr
See \link{re2_syntax} for regular expression syntax. \cr}
}
\value{
\code{re2_subset} returns a character vector, and \code{re2_which}
  returns an integer vector.
}
\description{
\code{re2_subset} returns strings that match a pattern.
\code{re2_which} is equivalent to grep(pattern, x). It returns
  position of string that match a pattern. Vectorized over
  string and pattern. For the equivalent of
  grepl(pattern, x) see \code{\link{re2_detect}}.
}
\examples{
color <- c("yellowgreen", "steelblue", "GOLDENROD", "forestgreen")
re2_which(color, "o")
re2_subset(color, "o")

re2_which(c("x", "y", NA, "foo", ""), ".")
re2_subset(c("x", "y", NA, "foo", ""), ".")

# Use precompiled regexp
re <- re2_regexp("[a-z]")
re2_which(color, re)
re2_subset(color, re)

re <- re2_regexp("[a-z]", case_sensitive = FALSE)
re2_which(color, re)
re2_subset(color, re)

# Vector of patterns
re2_which(color, c("^o", "bl.e$", re, "$"))
}
\seealso{
\code{\link{re2_regexp}} for options to regular expression,
  \link{re2_syntax} for regular expression syntax, and
  \code{\link{re2_detect}} to find presence of a pattern (grep).
}
