#' Distribuția pe zile a lecțiilor cuplajelor și membrilor acestora
#'
#' Cumulând (de pe liniile unde apare), putem constata cât este de omogenă
#' distribuția pe zile a fiecărui profesor angajat în cuplaje.
#'
#' @param DZ Distribuția curentă a tuturor lecțiilor
#' @return Matricea distribuțiilor lecțiilor cuplate
#' @export
#'
coupled_dis <- function(DZ) {
    if(is.null(cache_env$prof1))
        set_prof1_tw1(DZ)
    if(is.null(cache_env$tw1)) return(NULL)
    TW <- cache_env$tw1
    ntw <- TW %>% unlist() %>% as.vector() %>% unique()
    D <- DZ %>% filter(.data$prof %in% c(names(TW), ntw)) %>% droplevels()
    table(D[c('prof', 'zl')])
}

#' Distribuțiile pe zile, pentru membrii cuplajelor
#'
#' Pentru fiecare membru al unor cuplaje (care are și ore proprii) se
#' înscrie într-o listă matricea distribuțiilor acestuia. Consultând
#' aceste matrice se pot stabili re-alocări de zile prin care să se
#' echilibreze distribuțiile respective.
#'
#' @param DZ Distribuția curentă a tuturor lecțiilor
#' @return Lista matricelor distribuțiilor fiecărui membru cu ore proprii
#'     care este angajat în cuplaje (și suma cumulată de ore/zi)
#' @export
#'
coupled_list <- function(DZ) {
    Mcd <- coupled_dis(DZ)
    Pc <- rownames(Mcd)
    Pc1 <- Pc[nchar(Pc) == 3]
    map(Pc1, function(P) 
        Mcd[grepl(P, Pc), ]  %>% 
        addmargins(margin = 1)
    ) %>% setNames(Pc1)
}

#' Existența vreunei clase care să ajungă la a 6-a sau a 7-a oră a unei zile,
#' pentru un membru al unor cuplaje
#'
#' Cumulând orele proprii cu cele din cuplajele în care este implicat,
#' profesorul poate ajunge în vreo zi, la 6 sau 7 ore; dar se poate ca
#' niciuna dintre clasele sale din ziua respectivă, să nu aibă pe acea zi,
#' decât numai 5, respectiv numai 6 ore...
#'
#' @param DZ Distribuția curentă pe zile, a lecțiilor
#' @param P Profesorul, dintre cei cu ore proprii și implicați în cuplaje
#' @return 
#'     TRUE dacă pentru oricare zi, există clase la care 'P' să poată intra
#'          în ultima oră din zi.
#'     Alfel, zilele în care lecțiile alocate lui 'P' nu încap la clasele
#'          respective și distribuțiile pe zile pentru aceste clase
#' @export
#'
cls_last <- function(DZ, P) {
    Lmc <- coupled_list(DZ)
    stopifnot("'P' must have own hours and hours in couplings" =
              P %in% names(Lmc))
    Lp <- Lmc[[P]]
    M <- cls2prof(DZ, setdiff(rownames(Lp), "Sum"))
    dz <- Lp["Sum", ]
    la <- apply(M, 1, function(cls_zi)
              strsplit(cls_zi, " ")[[1]] %>% unique())
    ldz <- lapply(Zile, function(zi) {
        Q <- matrix(0L, ncol=5, nrow = length(la[[zi]]), 
                 byrow = TRUE, dimnames = list(c(la[[zi]]), levels(Zile)))
        for(Cls in la[[zi]])
            Q[Cls, ] <- cls_dis(DZ, Cls)
        if(all(Q[, zi] < dz[zi])) 
            Q
    }) %>% setNames(Zile) %>% compact()
    ldz
}
