% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/play.R
\name{play}
\alias{play}
\title{Validate New Data by Playing a Data Tape on It}
\usage{
play(tape, newdata, verbose = TRUE)
}
\arguments{
\item{tape}{\code{data.tape} statistics and meta data recorded from 
training data.}

\item{newdata}{\code{data.frame} new data to be predicted with an existing 
predictive model.}

\item{verbose}{\code{logical} should messages be printed?}
}
\value{
\code{data.playback} results from validation tests.
}
\description{
Runs a set of validation tests on new data to be predicted with an existing 
predictive model. These tests are based on statistics and meta data of
the variables in the training data - recorded with \code{\link{record}}.
}
\details{
Look up the descriptions and other meta data of the available 
validation tests with \code{\link{get_tests_meta_data}}.
}
\examples{
# record tape from `iris`.
tape <- record(iris)
# load data.
data(iris_newdata)
# validate new data by playing new tape on it.
play(tape, iris_newdata)
}
