% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportInstruments.R
\name{exportInstruments}
\alias{exportInstruments}
\alias{exportInstruments.redcapApiConnection}
\title{Export Instruments Defined in a Project}
\usage{
exportInstruments(rcon, ...)

\method{exportInstruments}{redcapApiConnection}(rcon, ...)
}
\arguments{
\item{rcon}{A \code{redcapConnection} object.}

\item{...}{Arguments to pass to other methods}
}
\value{
Returns a data frame with the columns:\tabular{ll}{
    \tab  \cr
   \code{instrument_name} \tab The REDCap generated instrument name. \cr
   \code{instrument_label} \tab The user provided instrument label. \cr
}
}
\description{
These methods enable the user to view the instruments defined
in the project.
}
\examples{
\dontrun{
unlockREDCap(connections = c(rcon = "project_alias"), 
             url = "your_redcap_url", 
             keyring = "API_KEYs", 
             envir = globalenv())
 
exportInstruments(rcon)
}

}
\seealso{
\code{\link[=exportMetaData]{exportMetaData()}},\cr
\code{\link[=importMetaData]{importMetaData()}}, \cr
\code{\link[=exportInstruments]{exportInstruments()}},\cr
\code{\link[=exportMappings]{exportMappings()}},\cr
\code{\link[=importMappings]{importMappings()}}, \cr
\code{\link[=exportPdf]{exportPdf()}}
}
