% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refseq_AAlen.R
\name{refseq_AAlen}
\alias{refseq_AAlen}
\title{Get the amino acid length from a protein accession}
\usage{
refseq_AAlen(protein)
}
\arguments{
\item{protein}{A character string of the protein id.}
}
\value{
A numeric value representing the aa length of the \code{protein}.
}
\description{
\code{refseq_AAlen()} Returns the amino acid length from a single protein accession.

Depending on the function, available accessions in \code{refseqR} include RefSeq models with the prefixes XM_ (mRNA), XR_ (non-coding RNA), and XP_ (protein), as well as subsequently curated RefSeq records with NM_, NR_, or NP_ accession prefixes.
}
\examples{
 # Get the amino acid lengths from a set of protein accessions
 protein = c("XP_004487758", "XP_004488550")
 sapply(protein, function(x) refseq_AAlen(x), USE.NAMES = FALSE)

}
\seealso{
\code{\link{refseq_RNA2protein}} to obtain the protein ids encoded by a set of transcript ids.
}
\author{
Jose V. Die
}
