% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refseq_AAmol_wt.R
\name{refseq_AAmol_wt}
\alias{refseq_AAmol_wt}
\title{Extract the molecular weight from a protein accession}
\usage{
refseq_AAmol_wt(protein)
}
\arguments{
\item{protein}{A character string of the protein id.}
}
\value{
A numeric vector representing the molecular weight of the \code{protein}.
}
\description{
\code{refseq_AAmol_wt()} Parses a protein accession output (RefSeq format) and extract the molecular weight
(in Daltons).

Depending on the function, available accessions in \code{refseqR} include RefSeq models with the prefixes XM_ (mRNA), XR_ (non-coding RNA), and XP_ (protein), as well as subsequently curated RefSeq records with NM_, NR_, or NP_ accession prefixes.
}
\details{
First, get the character vector containing the fetched record. Then, this
function parses the fetched record and returns the molecular weight.
}
\examples{
 # Get the molecular weight from a single protein accession
 protein <- "XP_020244413"
 refseq_AAmol_wt(protein)

\donttest{
 # Get the molecular weight from from a set of protein accessions
 protein = c("XP_004487758", "XP_004488550")
 sapply(protein, function(x) refseq_AAmol_wt(x), USE.NAMES = TRUE)}

}
\seealso{
\code{\link{refseq_RNA2protein}} to obtain the protein ids encoded by a set of transcript ids.
}
\author{
Jose V. Die
}
