% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_reptiledbr.R
\name{list_subspecies_reptiledbr}
\alias{list_subspecies_reptiledbr}
\title{List Subspecies from ReptileDB}
\usage{
list_subspecies_reptiledbr(df)
}
\arguments{
\item{df}{A dataframe or tibble result from using reptiledbr_exact,
reptiledbr_partial or search_reptiledbr functions.}
}
\value{
A tibble with three columns:
\item{species}{The name of the species}
\item{subspecies_name}{The full name of the subspecies}
\item{author}{The author and year of the subspecies description}
}
\description{
This function processes results from a ReptileDB database search to extract subspecies information.
It identifies species that have subspecies and returns a tibble with the species name,
subspecies name, and author information.
}
\examples{
\dontrun{
# These examples require the 'reptiledb.data' package to be installed.
subspecies_names <- c("Lachesis muta",
  "Anilius scytale",
  "Anolis bahorucoensis")

search_reptiledbr(subspecies_names, use_fuzzy = FALSE) |>
  list_subspecies_reptiledbr()
}

}
