% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_reptiledbr.R
\name{search_reptiledbr}
\alias{search_reptiledbr}
\title{Comprehensive Search for Reptile Species with Exact and Fuzzy Matching}
\usage{
search_reptiledbr(species_names, max_dist = 2, use_fuzzy = TRUE)
}
\arguments{
\item{species_names}{Character vector of scientific species names to search for.}

\item{max_dist}{Maximum string distance allowed for fuzzy matching (default: 2).}

\item{use_fuzzy}{Logical. If TRUE, performs fuzzy search for species not found exactly.
If FALSE, only does exact matching (default: TRUE).}
}
\value{
A combined tibble with results from both exact and fuzzy matching approaches,
with a flag indicating the match type. Results maintain the original order of species_names.
The response variable may return different messages depending on the outcome of the query.
Possible values include:
\itemize{
\item \code{"Species not found"} – The specified species could not be matched in the database.
\item \code{"Species has subspecies"} – The specified species exists and has one or more subspecies registered.
\item \code{"No subspecies found"} – The species was found, but there are no subspecies associated with it in the database.
}
}
\description{
This function combines both exact and fuzzy matching approaches to search for
reptile species names in the database. It first attempts exact matches and then
uses fuzzy matching for any species names that weren't found exactly.
}
\examples{
\dontrun{
# These examples require the 'reptiledb.data' package to be installed.
search_reptiledbr(c("Ablepharus alaicus", "Anolis limom"))
}
}
