% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_eurostat_codelist.R
\name{get_eurostat_codelist}
\alias{get_eurostat_codelist}
\title{Download the codelist of a concept}
\usage{
get_eurostat_codelist(
  id,
  lang = "en",
  cache = TRUE,
  update_cache = FALSE,
  cache_dir = NULL,
  compress_file = TRUE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{id}{a character string with id of the concept. It is a value from the \code{concept} column of the \code{\link{get_eurostat_dsd}} function.}

\item{lang}{a character string either \code{en}, \code{de} or \code{fr} to define the language version for the name column of the codelist. It is used only in the new API. The default is \code{en} - English.}

\item{cache}{a boolean whether to load/save the TOC from/in the cache or not. The default value is \code{TRUE}, so that the TOC is checked first in the cache and if does not exist then downloaded from Eurostat and cached.}

\item{update_cache}{a boolean to update cache or not. The default value is \code{FALSE}, so the cache is not updated. Can be set also with \code{options(restatapi_update=TRUE)}}

\item{cache_dir}{a path to a cache directory. The default is \code{NULL}, in this case the TOC is cached in the memory (in the '.restatapi_env'). Otherwise if the \code{cache_dir} directory does not exist it creates the 'restatapi' directory in the temporary directory from \code{tempdir()} to save the RDS-file. Directory can also be set with \code{option(restatapi_cache_dir=...)}.}

\item{compress_file}{a logical whether to compress the RDS-file in caching. Default is \code{TRUE}.}

\item{verbose}{A boolean with default \code{FALSE}, so detailed messages (for debugging) will not printed.
Can be set also with \code{options(restatapi_verbose=TRUE)}}

\item{...}{parameter to pass on the \code{load_cfg} function}
}
\value{
If the codelist does not exist it returns \code{NULL} otherwise the result is a table with the 2 columns:
   \tabular{ll}{
     \code{code} \tab All the possible codes under the concept \cr
     \code{name} \tab The name/description of the code 
   }
}
\description{
Download codelist of a concept from Eurostat if it is not cached previously.
}
\details{
The codelist is downloaded from Eurostat's website, through the REST API in XML (SDMX-ML) format.
}
\examples{
if (!(grepl("amzn|-aws|-azure ",Sys.info()['release']))) options(timeout=2)
get_eurostat_codelist("freq",lang="de",cache=FALSE,verbose=TRUE)
options(timeout=60)
}
\references{
For more information see the detailed documentation of the \href{https://ec.europa.eu/eurostat/web/user-guides/data-browser/api-data-access}{API}.
}
\seealso{
\code{\link{get_eurostat_dsd}}.
}
