% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PathOutline.R
\name{PathOutline}
\alias{PathOutline}
\title{Add point fullcuts to the outline}
\value{
To the \code{\link{Outline}} object this adds
\item{\code{hf}}{point cut mapping in forward direction for
points on boundary}
\item{\code{hb}}{point cut mapping in backward direction for
points on boundary}
}
\description{
Add point fullcuts to the outline

Add point fullcuts to the outline
}
\details{
The member function \code{stitchSubpaths()} stitches together two
subpaths of the outline. One subpath is stitched in the forward
direction from the point indexed by \code{VF0} to the point
indexed by \code{VF1}. The other is stitched in the backward
direction from \code{VB0} to \code{VB1}. Each point in the subpath
is linked to points in the opposing pathway at an equal or
near-equal fraction along. If a point exists in the opposing
pathway within a distance \code{epsilon} of the projection, this
point is connected. If no point exists within this tolerance, a
new point is created.
}
\section{Super classes}{
\code{\link[retistruct:OutlineCommon]{retistruct::OutlineCommon}} -> \code{\link[retistruct:Outline]{retistruct::Outline}} -> \code{PathOutline}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{hf}}{Forward fullcuts}

\item{\code{hb}}{Backward fullcuts}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PathOutline-addPoints}{\code{PathOutline$addPoints()}}
\item \href{#method-PathOutline-nextPoint}{\code{PathOutline$nextPoint()}}
\item \href{#method-PathOutline-insertPoint}{\code{PathOutline$insertPoint()}}
\item \href{#method-PathOutline-stitchSubpaths}{\code{PathOutline$stitchSubpaths()}}
\item \href{#method-PathOutline-clone}{\code{PathOutline$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="OutlineCommon" data-id="clearFeatureSets"><a href='../../retistruct/html/OutlineCommon.html#method-OutlineCommon-clearFeatureSets'><code>retistruct::OutlineCommon$clearFeatureSets()</code></a></span></li>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="OutlineCommon" data-id="getFeatureSet"><a href='../../retistruct/html/OutlineCommon.html#method-OutlineCommon-getFeatureSet'><code>retistruct::OutlineCommon$getFeatureSet()</code></a></span></li>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="OutlineCommon" data-id="getFeatureSetTypes"><a href='../../retistruct/html/OutlineCommon.html#method-OutlineCommon-getFeatureSetTypes'><code>retistruct::OutlineCommon$getFeatureSetTypes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="OutlineCommon" data-id="getFeatureSets"><a href='../../retistruct/html/OutlineCommon.html#method-OutlineCommon-getFeatureSets'><code>retistruct::OutlineCommon$getFeatureSets()</code></a></span></li>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="OutlineCommon" data-id="getIDs"><a href='../../retistruct/html/OutlineCommon.html#method-OutlineCommon-getIDs'><code>retistruct::OutlineCommon$getIDs()</code></a></span></li>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="Outline" data-id="addFeatureSet"><a href='../../retistruct/html/Outline.html#method-Outline-addFeatureSet'><code>retistruct::Outline$addFeatureSet()</code></a></span></li>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="Outline" data-id="getDepth"><a href='../../retistruct/html/Outline.html#method-Outline-getDepth'><code>retistruct::Outline$getDepth()</code></a></span></li>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="Outline" data-id="getFragment"><a href='../../retistruct/html/Outline.html#method-Outline-getFragment'><code>retistruct::Outline$getFragment()</code></a></span></li>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="Outline" data-id="getFragmentIDs"><a href='../../retistruct/html/Outline.html#method-Outline-getFragmentIDs'><code>retistruct::Outline$getFragmentIDs()</code></a></span></li>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="Outline" data-id="getFragmentIDsFromPointIDs"><a href='../../retistruct/html/Outline.html#method-Outline-getFragmentIDsFromPointIDs'><code>retistruct::Outline$getFragmentIDsFromPointIDs()</code></a></span></li>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="Outline" data-id="getFragmentPointIDs"><a href='../../retistruct/html/Outline.html#method-Outline-getFragmentPointIDs'><code>retistruct::Outline$getFragmentPointIDs()</code></a></span></li>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="Outline" data-id="getFragmentPoints"><a href='../../retistruct/html/Outline.html#method-Outline-getFragmentPoints'><code>retistruct::Outline$getFragmentPoints()</code></a></span></li>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="Outline" data-id="getImage"><a href='../../retistruct/html/Outline.html#method-Outline-getImage'><code>retistruct::Outline$getImage()</code></a></span></li>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="Outline" data-id="getOutlineLengths"><a href='../../retistruct/html/Outline.html#method-Outline-getOutlineLengths'><code>retistruct::Outline$getOutlineLengths()</code></a></span></li>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="Outline" data-id="getOutlineSet"><a href='../../retistruct/html/Outline.html#method-Outline-getOutlineSet'><code>retistruct::Outline$getOutlineSet()</code></a></span></li>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="Outline" data-id="getPoints"><a href='../../retistruct/html/Outline.html#method-Outline-getPoints'><code>retistruct::Outline$getPoints()</code></a></span></li>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="Outline" data-id="getPointsScaled"><a href='../../retistruct/html/Outline.html#method-Outline-getPointsScaled'><code>retistruct::Outline$getPointsScaled()</code></a></span></li>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="Outline" data-id="getPointsXY"><a href='../../retistruct/html/Outline.html#method-Outline-getPointsXY'><code>retistruct::Outline$getPointsXY()</code></a></span></li>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="Outline" data-id="getRimSet"><a href='../../retistruct/html/Outline.html#method-Outline-getRimSet'><code>retistruct::Outline$getRimSet()</code></a></span></li>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="Outline" data-id="initialize"><a href='../../retistruct/html/Outline.html#method-Outline-initialize'><code>retistruct::Outline$initialize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="Outline" data-id="mapFragment"><a href='../../retistruct/html/Outline.html#method-Outline-mapFragment'><code>retistruct::Outline$mapFragment()</code></a></span></li>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="Outline" data-id="mapPids"><a href='../../retistruct/html/Outline.html#method-Outline-mapPids'><code>retistruct::Outline$mapPids()</code></a></span></li>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="Outline" data-id="replaceImage"><a href='../../retistruct/html/Outline.html#method-Outline-replaceImage'><code>retistruct::Outline$replaceImage()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PathOutline-addPoints"></a>}}
\if{latex}{\out{\hypertarget{method-PathOutline-addPoints}{}}}
\subsection{Method \code{addPoints()}}{
Add points to the outline register of points
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PathOutline$addPoints(P, fid)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{P}}{2 column matrix of points to add}

\item{\code{fid}}{fragment id of the points}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The ID of each added point in the register. If points already
  exist a point will not be created in the register,
  but an ID will be returned
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PathOutline-nextPoint"></a>}}
\if{latex}{\out{\hypertarget{method-PathOutline-nextPoint}{}}}
\subsection{Method \code{nextPoint()}}{
Get next point in path for
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PathOutline$nextPoint(pids)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pids}}{Point IDs of points to get next position}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PathOutline-insertPoint"></a>}}
\if{latex}{\out{\hypertarget{method-PathOutline-insertPoint}{}}}
\subsection{Method \code{insertPoint()}}{
Insert point at a fractional distance between points
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PathOutline$insertPoint(i0, i1, f)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{i0}}{Point ID of first point}

\item{\code{i1}}{Point ID of second point}

\item{\code{f}}{Fraction of distance  between points \code{i0} and
\code{i1} at which to insert point}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PathOutline-stitchSubpaths"></a>}}
\if{latex}{\out{\hypertarget{method-PathOutline-stitchSubpaths}{}}}
\subsection{Method \code{stitchSubpaths()}}{
Stitch subpaths
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PathOutline$stitchSubpaths(VF0, VF1, VB0, VB1, epsilon)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{VF0}}{First vertex of \dQuote{forward} subpath}

\item{\code{VF1}}{Second vertex of \dQuote{forward} subpath}

\item{\code{VB0}}{First vertex of \dQuote{backward} subpath}

\item{\code{VB1}}{Second vertex of \dQuote{backward} subpath}

\item{\code{epsilon}}{Minimum distance between points}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PathOutline-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PathOutline-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PathOutline$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
