% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ReconstructedOutline.R
\name{ReconstructedOutline}
\alias{ReconstructedOutline}
\title{Class containing functions to reconstruct \link{StitchedOutline}s
and store the associated data}
\description{
The function \code{reconstruct} reconstructs outline
  into spherical surface Reconstruct outline into spherical
  surface.
}
\author{
David Sterratt
}
\section{Super class}{
\code{\link[retistruct:OutlineCommon]{retistruct::OutlineCommon}} -> \code{ReconstructedOutline}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{ol}}{Annotated outline}

\item{\code{ol0}}{Original Annotated outline}

\item{\code{Pt}}{Transformed cartesian mesh points}

\item{\code{Trt}}{Transformed triangulation}

\item{\code{Ct}}{Transformed links}

\item{\code{Cut}}{Transformed links}

\item{\code{Bt}}{Transformed binary vector representation
of edge indices onto a binary vector representation of the
indices of the points linked by the edge}

\item{\code{Lt}}{Transformed lengths}

\item{\code{ht}}{Transformed correspondences}

\item{\code{u}}{Indices of unique points in untransformed space}

\item{\code{U}}{Transformed indices of unique points in untransformed space}

\item{\code{Rsett}}{Transformed rim set}

\item{\code{i0t}}{Transformed marker}

\item{\code{H}}{mapping from edges onto corresponding edges}

\item{\code{Ht}}{Transformed mapping from edges onto corresponding edges}

\item{\code{phi0}}{Rim angle}

\item{\code{R}}{Radius of spherical template}

\item{\code{lambda0}}{Longitude of pole on rim}

\item{\code{lambda}}{Longitudes of transformed mesh points}

\item{\code{phi}}{Latitudes of transformed mesh points}

\item{\code{Ps}}{Location of mesh point on sphere in spherical coordinates}

\item{\code{n}}{Number of mesh points}

\item{\code{alpha}}{Weighting of areas in energy function}

\item{\code{x0}}{Area cut-off coefficient}

\item{\code{nflip0}}{Initial number flipped triangles}

\item{\code{nflip}}{Final number flipped triangles}

\item{\code{opt}}{Optimisation object}

\item{\code{E.tot}}{Energy function including area}

\item{\code{E.l}}{Energy function based on lengths alone}

\item{\code{mean.strain}}{Mean strain}

\item{\code{mean.logstrain}}{Mean log strain}

\item{\code{titration}}{Titrated data structure, saved by \code{titrate}}

\item{\code{debug}}{Debug function}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ReconstructedOutline-loadOutline}{\code{ReconstructedOutline$loadOutline()}}
\item \href{#method-ReconstructedOutline-reconstruct}{\code{ReconstructedOutline$reconstruct()}}
\item \href{#method-ReconstructedOutline-mergePointsEdges}{\code{ReconstructedOutline$mergePointsEdges()}}
\item \href{#method-ReconstructedOutline-projectToSphere}{\code{ReconstructedOutline$projectToSphere()}}
\item \href{#method-ReconstructedOutline-getStrains}{\code{ReconstructedOutline$getStrains()}}
\item \href{#method-ReconstructedOutline-optimiseMapping}{\code{ReconstructedOutline$optimiseMapping()}}
\item \href{#method-ReconstructedOutline-optimiseMappingCart}{\code{ReconstructedOutline$optimiseMappingCart()}}
\item \href{#method-ReconstructedOutline-transformImage}{\code{ReconstructedOutline$transformImage()}}
\item \href{#method-ReconstructedOutline-getIms}{\code{ReconstructedOutline$getIms()}}
\item \href{#method-ReconstructedOutline-getTearCoords}{\code{ReconstructedOutline$getTearCoords()}}
\item \href{#method-ReconstructedOutline-getFullCutCoords}{\code{ReconstructedOutline$getFullCutCoords()}}
\item \href{#method-ReconstructedOutline-getNonRimBoundaryCoords}{\code{ReconstructedOutline$getNonRimBoundaryCoords()}}
\item \href{#method-ReconstructedOutline-getFeatureSet}{\code{ReconstructedOutline$getFeatureSet()}}
\item \href{#method-ReconstructedOutline-reconstructFeatureSets}{\code{ReconstructedOutline$reconstructFeatureSets()}}
\item \href{#method-ReconstructedOutline-getPoints}{\code{ReconstructedOutline$getPoints()}}
\item \href{#method-ReconstructedOutline-mapFlatToSpherical}{\code{ReconstructedOutline$mapFlatToSpherical()}}
\item \href{#method-ReconstructedOutline-titrate}{\code{ReconstructedOutline$titrate()}}
\item \href{#method-ReconstructedOutline-clone}{\code{ReconstructedOutline$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="OutlineCommon" data-id="clearFeatureSets"><a href='../../retistruct/html/OutlineCommon.html#method-OutlineCommon-clearFeatureSets'><code>retistruct::OutlineCommon$clearFeatureSets()</code></a></span></li>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="OutlineCommon" data-id="getFeatureSetTypes"><a href='../../retistruct/html/OutlineCommon.html#method-OutlineCommon-getFeatureSetTypes'><code>retistruct::OutlineCommon$getFeatureSetTypes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="OutlineCommon" data-id="getFeatureSets"><a href='../../retistruct/html/OutlineCommon.html#method-OutlineCommon-getFeatureSets'><code>retistruct::OutlineCommon$getFeatureSets()</code></a></span></li>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="OutlineCommon" data-id="getIDs"><a href='../../retistruct/html/OutlineCommon.html#method-OutlineCommon-getIDs'><code>retistruct::OutlineCommon$getIDs()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ReconstructedOutline-loadOutline"></a>}}
\if{latex}{\out{\hypertarget{method-ReconstructedOutline-loadOutline}{}}}
\subsection{Method \code{loadOutline()}}{
Load \link{AnnotatedOutline} into ReconstructedOutline object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ReconstructedOutline$loadOutline(
  ol,
  n = 500,
  alpha = 8,
  x0 = 0.5,
  plot.3d = FALSE,
  dev.flat = NA,
  dev.polar = NA,
  report = retistruct::report,
  debug = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ol}}{\code{\link{AnnotatedOutline}} object, containing the following information}

\item{\code{n}}{Number of points in triangulation.}

\item{\code{alpha}}{Area scaling coefficient}

\item{\code{x0}}{Area cut-off coefficient}

\item{\code{plot.3d}}{Whether to show 3D picture during optimisation.}

\item{\code{dev.flat}}{Device to plot grid onto. Value of \code{NA} (default)
means no plotting.}

\item{\code{dev.polar}}{Device display projection. Value of NA
(default) means no plotting.}

\item{\code{report}}{Function to report progress.}

\item{\code{debug}}{If \code{TRUE} print extra debugging output}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ReconstructedOutline-reconstruct"></a>}}
\if{latex}{\out{\hypertarget{method-ReconstructedOutline-reconstruct}{}}}
\subsection{Method \code{reconstruct()}}{
Reconstruct
Reconstruction proceeds in a number of stages:

\enumerate{

\item The flat object is triangulated with at least \code{n}
triangles. This can introduce new vertices in the rim.

\item The triangulated object is stitched.

\item The stitched object is triangulated again, but this time it
is not permitted to add extra vertices to the rim.

\item The corresponding points determined by the stitching process
are merged to form a new set of merged points and a new
triangulation.

\item The merged points are projected roughly to a sphere.

\item The locations of the points on the sphere are moved so as to
minimise the energy function.
}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ReconstructedOutline$reconstruct(
  plot.3d = FALSE,
  dev.flat = NA,
  dev.polar = NA,
  shinyOutput = NA,
  report = getOption("retistruct.report")
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{plot.3d}}{If \code{TRUE} make a 3D plot in an RGL window}

\item{\code{dev.flat}}{Device handle for plotting flatplot updates to. If
\code{NA} don't make any flat plots}

\item{\code{dev.polar}}{Device handle for plotting polar plot updates
to. If \code{NA} don't make any polar plots.}

\item{\code{shinyOutput}}{A Shiny output element used to render and display a
plot in the application. If \code{NA} or \code{NULL} don't output to Shiny.}

\item{\code{report}}{Function to report progress.}

\item{\code{Control}}{argument to pass to \code{optim}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ReconstructedOutline-mergePointsEdges"></a>}}
\if{latex}{\out{\hypertarget{method-ReconstructedOutline-mergePointsEdges}{}}}
\subsection{Method \code{mergePointsEdges()}}{
Merge stitched points and edges.
Create merged and transformed versions (all suffixed with \code{t})
of a number of existing variables, as well
as a matrix \code{Bt}, which maps a binary vector representation
of edge indices onto a binary vector representation of the
indices of the points linked by the edge.
Sets following fields
\describe{
\item{\code{Pt}}{Transformed point locations}
\item{\code{Trt}}{Transformed triangulation}
\item{\code{Ct}}{Transformed connection set}
\item{\code{Cut}}{Transformed symmetric connection set}
\item{\code{Bt}}{Transformed binary vector representation
of edge indices onto a binary vector representation of the
indices of the points linked by the edge}
\item{\code{Lt}}{Transformed edge lengths}
\item{\code{ht}}{Transformed correspondences}
\item{\code{u}}{Indices of unique points in untransformed space}
\item{\code{U}}{Transformed indices of unique points in untransformed space}
\item{\code{Rset}}{The set of points on the rim (which has been reordered)}
\item{\code{Rsett}}{Transformed set of points on rim}
\item{\code{i0t}}{Transformed index of the landmark}
\item{\code{H}}{mapping from edges onto corresponding edges}
\item{\code{Ht}}{Transformed mapping from edges onto corresponding edges}
}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ReconstructedOutline$mergePointsEdges()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ReconstructedOutline-projectToSphere"></a>}}
\if{latex}{\out{\hypertarget{method-ReconstructedOutline-projectToSphere}{}}}
\subsection{Method \code{projectToSphere()}}{
Project mesh points in the flat outline onto a sphere
This takes the mesh points from the flat outline and maps them to
the curtailed sphere. It uses the area of the flat outline and
\code{phi0} to determine the radius \code{R} of the sphere. It
tries to get a good first approximation by using the function
\code{\link{stretchMesh}}.
The following fields are set:
\describe{
\item{\code{phi}}{Latitude of mesh points.}
\item{\code{lmabda}}{Longitude of mesh points.}
\item{\code{R}}{Radius of sphere.}
}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ReconstructedOutline$projectToSphere()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ReconstructedOutline-getStrains"></a>}}
\if{latex}{\out{\hypertarget{method-ReconstructedOutline-getStrains}{}}}
\subsection{Method \code{getStrains()}}{
Return strains edges are under in spherical retina
Set information about how edges on the sphere
have been deformed from their flat state.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ReconstructedOutline$getStrains()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list containing two data frames \code{flat} and \code{spherical}.
Each data frame contains for each edge in the flat or spherical meshes:
\describe{
\item{\code{L}}{Length of the edge in the flat outline }
\item{\code{l}}{Length of the corresponding edge on the sphere}
\item{\code{strain}}{The strain of each connection}
\item{\code{logstrain}}{The logarithmic strain of each connection}
}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ReconstructedOutline-optimiseMapping"></a>}}
\if{latex}{\out{\hypertarget{method-ReconstructedOutline-optimiseMapping}{}}}
\subsection{Method \code{optimiseMapping()}}{
Optimise the mapping from the flat outline to the sphere
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ReconstructedOutline$optimiseMapping(
  alpha = 4,
  x0 = 0.5,
  nu = 1,
  optim.method = "BFGS",
  plot.3d = FALSE,
  dev.flat = NA,
  dev.polar = NA,
  shinyOutput = NULL,
  control = list()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{alpha}}{Area penalty scaling coefficient}

\item{\code{x0}}{Area penalty cut-off coefficient}

\item{\code{nu}}{Power to which to raise area}

\item{\code{optim.method}}{Method to pass to \code{optim}}

\item{\code{plot.3d}}{If \code{TRUE} make a 3D plot in an RGL window}

\item{\code{dev.flat}}{Device handle for plotting flatplot updates to. If}

\item{\code{dev.polar}}{Device handle for plotting polar plot updates
to. If \code{NA} don't make any polar plots.}

\item{\code{shinyOutput}}{A Shiny output element used to render and display a
plot in the application.
\code{NA} don't make any flat plots}

\item{\code{control}}{Control argument to pass to \code{optim}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ReconstructedOutline-optimiseMappingCart"></a>}}
\if{latex}{\out{\hypertarget{method-ReconstructedOutline-optimiseMappingCart}{}}}
\subsection{Method \code{optimiseMappingCart()}}{
Optimise the mapping from the flat outline to the sphere
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ReconstructedOutline$optimiseMappingCart(
  alpha = 4,
  x0 = 0.5,
  nu = 1,
  method = "BFGS",
  plot.3d = FALSE,
  dev.flat = NA,
  dev.polar = NA,
  shinyOutput = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{alpha}}{Area penalty scaling coefficient}

\item{\code{x0}}{Area penalty cut-off coefficient}

\item{\code{nu}}{Power to which to raise area}

\item{\code{method}}{Method to pass to \code{optim}}

\item{\code{plot.3d}}{If \code{TRUE} make a 3D plot in an RGL window}

\item{\code{dev.flat}}{Device handle for plotting grid to}

\item{\code{dev.polar}}{Device handle for plotting polar plot to}

\item{\code{shinyOutput}}{A Shiny output element used to render and display a
plot in the application.}

\item{\code{...}}{Extra arguments to pass to \code{\link{fire}}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ReconstructedOutline-transformImage"></a>}}
\if{latex}{\out{\hypertarget{method-ReconstructedOutline-transformImage}{}}}
\subsection{Method \code{transformImage()}}{
Transform an image into the reconstructed space
Transform an image into the reconstructed space. The four corner
coordinates of each pixel are transformed into spherical
coordinates and a mask matrix with the same dimensions as
\code{im} is created. This has \code{TRUE} for pixels that should
be displayed and \code{FALSE} for ones that should not.
Sets the field
\describe{
\item{\code{ims}}{Coordinates of corners of pixels in spherical coordinates}
}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ReconstructedOutline$transformImage()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ReconstructedOutline-getIms"></a>}}
\if{latex}{\out{\hypertarget{method-ReconstructedOutline-getIms}{}}}
\subsection{Method \code{getIms()}}{
Get coordinates of corners of pixels of image in spherical
coordinates
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ReconstructedOutline$getIms()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Coordinates of corners of pixels in spherical coordinates
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ReconstructedOutline-getTearCoords"></a>}}
\if{latex}{\out{\hypertarget{method-ReconstructedOutline-getTearCoords}{}}}
\subsection{Method \code{getTearCoords()}}{
Get locations of tears in spherical coordinates
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ReconstructedOutline$getTearCoords()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
List containing locations of tears in spherical coordinates
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ReconstructedOutline-getFullCutCoords"></a>}}
\if{latex}{\out{\hypertarget{method-ReconstructedOutline-getFullCutCoords}{}}}
\subsection{Method \code{getFullCutCoords()}}{
Get locations of fullcuts in spherical coordinates
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ReconstructedOutline$getFullCutCoords()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
List containing locations of fullcuts in spherical coordinates
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ReconstructedOutline-getNonRimBoundaryCoords"></a>}}
\if{latex}{\out{\hypertarget{method-ReconstructedOutline-getNonRimBoundaryCoords}{}}}
\subsection{Method \code{getNonRimBoundaryCoords()}}{
Get location of non-rim boundaries in spherical coordinates
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ReconstructedOutline$getNonRimBoundaryCoords()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
List containing locations of non-rim boundaries in spherical coordinates
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ReconstructedOutline-getFeatureSet"></a>}}
\if{latex}{\out{\hypertarget{method-ReconstructedOutline-getFeatureSet}{}}}
\subsection{Method \code{getFeatureSet()}}{
Get \link{ReconstructedFeatureSet}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ReconstructedOutline$getFeatureSet(type)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{Base type of \link{FeatureSet} as string.
E.g. \code{PointSet} returns a \link{ReconstructedPointSet}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ReconstructedOutline-reconstructFeatureSets"></a>}}
\if{latex}{\out{\hypertarget{method-ReconstructedOutline-reconstructFeatureSets}{}}}
\subsection{Method \code{reconstructFeatureSets()}}{
Reconstruct any attached feature sets.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ReconstructedOutline$reconstructFeatureSets()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ReconstructedOutline-getPoints"></a>}}
\if{latex}{\out{\hypertarget{method-ReconstructedOutline-getPoints}{}}}
\subsection{Method \code{getPoints()}}{
Get mesh points in spherical coordinates
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ReconstructedOutline$getPoints()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Matrix with columns \code{phi} (latitude) and \code{lambda}
  (longitude)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ReconstructedOutline-mapFlatToSpherical"></a>}}
\if{latex}{\out{\hypertarget{method-ReconstructedOutline-mapFlatToSpherical}{}}}
\subsection{Method \code{mapFlatToSpherical()}}{
Return location of point on sphere corresponding
  to point on the flat outline
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ReconstructedOutline$mapFlatToSpherical(P)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{P}}{Cartesian coordinates  on flat outline as a matrix
with \code{X} and \code{Y} columns}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ReconstructedOutline-titrate"></a>}}
\if{latex}{\out{\hypertarget{method-ReconstructedOutline-titrate}{}}}
\subsection{Method \code{titrate()}}{
Try a range of values of phi0s in the reconstruction, recording the
energy of the mapping in each case.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ReconstructedOutline$titrate(
  alpha = 8,
  x0 = 0.5,
  byd = 1,
  len.up = 5,
  len.down = 20
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{alpha}}{Area penalty scaling coefficient}

\item{\code{x0}}{Area cut-off coefficient}

\item{\code{byd}}{Increments in degrees}

\item{\code{len.up}}{How many increments to go up from starting value of
\code{phi0} in \code{r}.}

\item{\code{len.down}}{How many increments to go up from starting value
of \code{phi0} in \code{r}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ReconstructedOutline-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ReconstructedOutline-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ReconstructedOutline$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
