% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ReconstructedPointSet.R
\name{ReconstructedPointSet}
\alias{ReconstructedPointSet}
\title{Class containing functions and data to map \link{PointSet}s to
\link{ReconstructedOutline}s}
\description{
A ReconstructedPointSet contains information about
  features located on \code{\link{ReconstructedOutline}}s. Each
  ReconstructedPointSet contains a list of matrices, each of
  which has columns labelled \code{phi} (latitude) and
  \code{lambda} (longitude) describing the spherical coordinates
  of points on the ReconstructedOutline.
}
\author{
David Sterratt
}
\section{Super classes}{
\code{\link[retistruct:FeatureSetCommon]{retistruct::FeatureSetCommon}} -> \code{\link[retistruct:ReconstructedFeatureSet]{retistruct::ReconstructedFeatureSet}} -> \code{ReconstructedPointSet}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{KDE}}{Kernel density estimate, computed using
\code{\link{compute.kernel.estimate}} in \code{getKDE}}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ReconstructedPointSet-getMean}{\code{ReconstructedPointSet$getMean()}}
\item \href{#method-ReconstructedPointSet-getHullarea}{\code{ReconstructedPointSet$getHullarea()}}
\item \href{#method-ReconstructedPointSet-getKDE}{\code{ReconstructedPointSet$getKDE()}}
\item \href{#method-ReconstructedPointSet-clone}{\code{ReconstructedPointSet$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="FeatureSetCommon" data-id="getCol"><a href='../../retistruct/html/FeatureSetCommon.html#method-FeatureSetCommon-getCol'><code>retistruct::FeatureSetCommon$getCol()</code></a></span></li>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="FeatureSetCommon" data-id="getFeature"><a href='../../retistruct/html/FeatureSetCommon.html#method-FeatureSetCommon-getFeature'><code>retistruct::FeatureSetCommon$getFeature()</code></a></span></li>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="FeatureSetCommon" data-id="getFeatures"><a href='../../retistruct/html/FeatureSetCommon.html#method-FeatureSetCommon-getFeatures'><code>retistruct::FeatureSetCommon$getFeatures()</code></a></span></li>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="FeatureSetCommon" data-id="getIDs"><a href='../../retistruct/html/FeatureSetCommon.html#method-FeatureSetCommon-getIDs'><code>retistruct::FeatureSetCommon$getIDs()</code></a></span></li>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="FeatureSetCommon" data-id="getIndex"><a href='../../retistruct/html/FeatureSetCommon.html#method-FeatureSetCommon-getIndex'><code>retistruct::FeatureSetCommon$getIndex()</code></a></span></li>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="FeatureSetCommon" data-id="setID"><a href='../../retistruct/html/FeatureSetCommon.html#method-FeatureSetCommon-setID'><code>retistruct::FeatureSetCommon$setID()</code></a></span></li>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="ReconstructedFeatureSet" data-id="initialize"><a href='../../retistruct/html/ReconstructedFeatureSet.html#method-ReconstructedFeatureSet-initialize'><code>retistruct::ReconstructedFeatureSet$initialize()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ReconstructedPointSet-getMean"></a>}}
\if{latex}{\out{\hypertarget{method-ReconstructedPointSet-getMean}{}}}
\subsection{Method \code{getMean()}}{
Get Karcher mean of datapoints in spherical coordinates
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ReconstructedPointSet$getMean()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Karcher mean of datapoints in spherical coordinates
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ReconstructedPointSet-getHullarea"></a>}}
\if{latex}{\out{\hypertarget{method-ReconstructedPointSet-getHullarea}{}}}
\subsection{Method \code{getHullarea()}}{
Get area of convex hull around data points on sphere
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ReconstructedPointSet$getHullarea()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Area in degrees squared
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ReconstructedPointSet-getKDE"></a>}}
\if{latex}{\out{\hypertarget{method-ReconstructedPointSet-getKDE}{}}}
\subsection{Method \code{getKDE()}}{
Get kernel density estimate of data points
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ReconstructedPointSet$getKDE()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
See \code{\link{compute.kernel.estimate}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ReconstructedPointSet-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ReconstructedPointSet-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ReconstructedPointSet$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
