% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RetinalReconstructedOutline.R
\name{RetinalReconstructedOutline}
\alias{RetinalReconstructedOutline}
\title{A version of \link{ReconstructedOutline} that is specific to
retinal datasets}
\description{
A RetinalReconstructedOutline overrides methods of
  \link{ReconstructedOutline} so that they return data point and
  landmark coordinates that have been transformed according to the
  values of \code{DVflip} and \code{side}. When reconstructing, it
  also computes the \dQuote{Optic disc displacement}, i.e. the
  number of degrees subtended between the optic disc and the pole.
}
\author{
David Sterratt
}
\section{Super classes}{
\code{\link[retistruct:OutlineCommon]{retistruct::OutlineCommon}} -> \code{\link[retistruct:ReconstructedOutline]{retistruct::ReconstructedOutline}} -> \code{RetinalReconstructedOutline}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{EOD}}{Optic disc displacement in degrees}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-RetinalReconstructedOutline-getIms}{\code{RetinalReconstructedOutline$getIms()}}
\item \href{#method-RetinalReconstructedOutline-getTearCoords}{\code{RetinalReconstructedOutline$getTearCoords()}}
\item \href{#method-RetinalReconstructedOutline-reconstruct}{\code{RetinalReconstructedOutline$reconstruct()}}
\item \href{#method-RetinalReconstructedOutline-getFeatureSet}{\code{RetinalReconstructedOutline$getFeatureSet()}}
\item \href{#method-RetinalReconstructedOutline-clone}{\code{RetinalReconstructedOutline$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="OutlineCommon" data-id="clearFeatureSets"><a href='../../retistruct/html/OutlineCommon.html#method-OutlineCommon-clearFeatureSets'><code>retistruct::OutlineCommon$clearFeatureSets()</code></a></span></li>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="OutlineCommon" data-id="getFeatureSetTypes"><a href='../../retistruct/html/OutlineCommon.html#method-OutlineCommon-getFeatureSetTypes'><code>retistruct::OutlineCommon$getFeatureSetTypes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="OutlineCommon" data-id="getFeatureSets"><a href='../../retistruct/html/OutlineCommon.html#method-OutlineCommon-getFeatureSets'><code>retistruct::OutlineCommon$getFeatureSets()</code></a></span></li>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="OutlineCommon" data-id="getIDs"><a href='../../retistruct/html/OutlineCommon.html#method-OutlineCommon-getIDs'><code>retistruct::OutlineCommon$getIDs()</code></a></span></li>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="ReconstructedOutline" data-id="getFullCutCoords"><a href='../../retistruct/html/ReconstructedOutline.html#method-ReconstructedOutline-getFullCutCoords'><code>retistruct::ReconstructedOutline$getFullCutCoords()</code></a></span></li>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="ReconstructedOutline" data-id="getNonRimBoundaryCoords"><a href='../../retistruct/html/ReconstructedOutline.html#method-ReconstructedOutline-getNonRimBoundaryCoords'><code>retistruct::ReconstructedOutline$getNonRimBoundaryCoords()</code></a></span></li>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="ReconstructedOutline" data-id="getPoints"><a href='../../retistruct/html/ReconstructedOutline.html#method-ReconstructedOutline-getPoints'><code>retistruct::ReconstructedOutline$getPoints()</code></a></span></li>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="ReconstructedOutline" data-id="getStrains"><a href='../../retistruct/html/ReconstructedOutline.html#method-ReconstructedOutline-getStrains'><code>retistruct::ReconstructedOutline$getStrains()</code></a></span></li>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="ReconstructedOutline" data-id="loadOutline"><a href='../../retistruct/html/ReconstructedOutline.html#method-ReconstructedOutline-loadOutline'><code>retistruct::ReconstructedOutline$loadOutline()</code></a></span></li>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="ReconstructedOutline" data-id="mapFlatToSpherical"><a href='../../retistruct/html/ReconstructedOutline.html#method-ReconstructedOutline-mapFlatToSpherical'><code>retistruct::ReconstructedOutline$mapFlatToSpherical()</code></a></span></li>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="ReconstructedOutline" data-id="mergePointsEdges"><a href='../../retistruct/html/ReconstructedOutline.html#method-ReconstructedOutline-mergePointsEdges'><code>retistruct::ReconstructedOutline$mergePointsEdges()</code></a></span></li>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="ReconstructedOutline" data-id="optimiseMapping"><a href='../../retistruct/html/ReconstructedOutline.html#method-ReconstructedOutline-optimiseMapping'><code>retistruct::ReconstructedOutline$optimiseMapping()</code></a></span></li>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="ReconstructedOutline" data-id="optimiseMappingCart"><a href='../../retistruct/html/ReconstructedOutline.html#method-ReconstructedOutline-optimiseMappingCart'><code>retistruct::ReconstructedOutline$optimiseMappingCart()</code></a></span></li>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="ReconstructedOutline" data-id="projectToSphere"><a href='../../retistruct/html/ReconstructedOutline.html#method-ReconstructedOutline-projectToSphere'><code>retistruct::ReconstructedOutline$projectToSphere()</code></a></span></li>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="ReconstructedOutline" data-id="reconstructFeatureSets"><a href='../../retistruct/html/ReconstructedOutline.html#method-ReconstructedOutline-reconstructFeatureSets'><code>retistruct::ReconstructedOutline$reconstructFeatureSets()</code></a></span></li>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="ReconstructedOutline" data-id="titrate"><a href='../../retistruct/html/ReconstructedOutline.html#method-ReconstructedOutline-titrate'><code>retistruct::ReconstructedOutline$titrate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="ReconstructedOutline" data-id="transformImage"><a href='../../retistruct/html/ReconstructedOutline.html#method-ReconstructedOutline-transformImage'><code>retistruct::ReconstructedOutline$transformImage()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RetinalReconstructedOutline-getIms"></a>}}
\if{latex}{\out{\hypertarget{method-RetinalReconstructedOutline-getIms}{}}}
\subsection{Method \code{getIms()}}{
Get coordinates of corners of pixels of image in spherical
  coordinates, transformed according to the value of \code{DVflip}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RetinalReconstructedOutline$getIms()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Coordinates of corners of pixels in spherical coordinates
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RetinalReconstructedOutline-getTearCoords"></a>}}
\if{latex}{\out{\hypertarget{method-RetinalReconstructedOutline-getTearCoords}{}}}
\subsection{Method \code{getTearCoords()}}{
Get location of tear coordinates in spherical coordinates,
  transformed according to the value of \code{DVflip}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RetinalReconstructedOutline$getTearCoords()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Location of tear coordinates in spherical coordinates
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RetinalReconstructedOutline-reconstruct"></a>}}
\if{latex}{\out{\hypertarget{method-RetinalReconstructedOutline-reconstruct}{}}}
\subsection{Method \code{reconstruct()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RetinalReconstructedOutline$reconstruct(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Parameters to \code{\link{ReconstructedOutline}}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RetinalReconstructedOutline-getFeatureSet"></a>}}
\if{latex}{\out{\hypertarget{method-RetinalReconstructedOutline-getFeatureSet}{}}}
\subsection{Method \code{getFeatureSet()}}{
Get \link{ReconstructedFeatureSet}, transformed
  according to the value of \code{DVflip}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RetinalReconstructedOutline$getFeatureSet(type)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{Base type of \link{FeatureSet} as string.
E.g. \code{PointSet} returns a \link{ReconstructedPointSet}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RetinalReconstructedOutline-clone"></a>}}
\if{latex}{\out{\hypertarget{method-RetinalReconstructedOutline-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RetinalReconstructedOutline$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
