% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/support.R
\name{read_exercise_excel}
\alias{read_exercise_excel}
\title{Read an exercise Excel file}
\usage{
read_exercise_excel(file, sheet_index = NULL, sheet_name = NULL)
}
\arguments{
\item{file}{A string, name of a text file.}

\item{sheet_index}{A number, sheet index in the workbook.}

\item{sheet_name}{A string, sheet name.}
}
\value{
A data frame.
}
\description{
Reads an Excel file of exercises and returns a data frame.
}
\details{
In addition to the file, we can indicate the sheet by its name or index. If we
do not indicate anything, it considers the first sheet.
}
\examples{

file <- system.file("extdata/exercises.csv", package = "rexer")
df <- read_exercise_csv(file)

}
\seealso{
Other support functions: 
\code{\link{create_exercise_csv}()},
\code{\link{create_exercise_data_frame}()},
\code{\link{create_exercise_excel}()},
\code{\link{read_exercise_csv}()},
\code{\link{set_pending_answers}()},
\code{\link{vector_to_string}()},
\code{\link{write_exercise_csv}()}
}
\concept{support functions}
