% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pScore.R
\name{pAbsLog10Score}
\alias{pAbsLog10Score}
\title{Transform p-values to continuous scores with the absolute-log10 transformation}
\usage{
pAbsLog10Score(p, sign = 1, replaceZero = TRUE)
}
\arguments{
\item{p}{\emph{p}-value(s) between (0,1]}

\item{sign}{Sign of the score, either positive (in case of positive
numbers), negative (in case of negative numbers), or zero.  In case a
logical vector, \code{TRUE} is interpreted as positive and \code{FALSE} is
interpreted as negative.}

\item{replaceZero}{Logical, whether to replace zero p-values with the 
minimal double value specified by the machine. Default is \code{TRUE}. If 
set to \code{FALSE}, results will contain infinite values.}
}
\value{
A numeric vector of transformed p-values using signed -log10 transformation.
}
\description{
The function maps p values between 0 and 1 to continuous scores ranging on \code{R} by the following equation: \eqn{abs(log10(p))*sign}
}
\examples{

testPvals <- c(0.001, 0.01, 0.05, 0.1, 0.5, 1)
pAbsLog10Score(testPvals)
testPvalSign <- rep(c(-1,1), 3)
pAbsLog10Score(testPvals, sign=testPvalSign)
testLog <- rep(c(TRUE, FALSE),3)
pAbsLog10Score(testPvals, testLog)

}
\seealso{
\code{\link{pQnormScore}}, \code{\link{pScore}}, \code{\link{replaceZeroPvalue}}
}
