% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.decomposition.R
\name{summary.decomposition}
\alias{summary.decomposition}
\title{Prints and returns a summary for a \code{decomposition} object.}
\usage{
\method{summary}{decomposition}(object, digits = getOption("digits"), addcoefs = FALSE, ...)
}
\arguments{
\item{object}{Result of a decomposition analysis, of class \code{decomposition}}

\item{digits}{Number of digits, defaults to R \code{digits} option}

\item{addcoefs}{Whether or not to add coefficients (defaults to \code{FALSE})}

\item{...}{Additional parameters, currently unused}
}
\value{
A data frame frame with columns for the absolute and relative contribution, elasticity, concentration index including confidence intervals,
and whether correction was applied. If specified using \code{addcoefs}, the coefficients are included as the first column.
}
\description{
Prints and returns a summary for a \code{decomposition} object.
}
\examples{
data(housing)
# Linear regression & decompose 
fit.lm <- lm(bmi ~ sex + tenure + place + age,data = housing)
contrib.lm <- contribution(fit.lm, housing$income)

# print
print(contrib.lm)
}
