% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/italic_description.R
\name{italic_description}
\alias{italic_description}
\title{Get descriptions of lichen taxa}
\usage{
italic_description(sp_names)
}
\arguments{
\item{sp_names}{Character vector of accepted names}
}
\value{
A data frame with columns:
\describe{
\item{scientific_name}{The scientific name provided as input}
\item{description}{Morphological description}
\item{notes}{Additional taxonomic or ecological information}
}
}
\description{
Retrieves morphological descriptions and additional taxonomic or ecological notes about lichen taxa present in the Checklist of the Lichens of Italy.
Only accepts names that exist in the database of ITALIC.
}
\note{
Before using this function with a list of names, first obtain their accepted names
using \code{italic_match()}.
Example workflow:
\preformatted{
      names_matched <- italic_match(your_names)
      descriptions <- italic_description(names_matched$accepted_name)
      }
}
\examples{
\dontrun{
italic_description("Cetraria islandica (L.) Ach. subsp. islandica")
}


}
