% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replaceVariables.R
\name{replaceVariables}
\alias{replaceVariables}
\title{Replace \code{rmake} variables in a character vector}
\usage{
replaceVariables(x, vars)
}
\arguments{
\item{x}{A character vector where to replace the \code{rmake} variables}

\item{vars}{A named character vector with variable definitions (names are variable names, values
are variable values)}
}
\value{
A character vector with \code{rmake} variables replaced with their values
}
\description{
This function searches for all \code{rmake} variables in the given vector \code{x} and replaces them
with their values that are defined in the \code{vars} argument. An \code{rmake} variable is identified
by the \verb{$[VARIABLE_NAME]} string.
}
\examples{
vars <- c(SIZE='small', METHOD='abc')
replaceVariables('result-$[SIZE]-$[METHOD].csv', vars)   # returns 'result-small-abc.csv'

}
\seealso{
\code{\link[=expandTemplate]{expandTemplate()}}
}
\author{
Michal Burda
}
