% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robomit_functions.R
\name{o_delta}
\alias{o_delta}
\title{delta*}
\usage{
o_delta(y, x, con, w = NULL, id = "none", time = "none", beta = 0, R2max,
type, data)
}
\arguments{
\item{y}{Name of the dependent variable (as string).}

\item{x}{Name of the independent treatment variable (i.e., variable of interest; as string).}

\item{con}{Name of related control variables. Provided as string in the format: "w + z +...".}

\item{w}{weights (only for weighted estimations). Warning: For weighted panel models R can report different R-square than Stata, leading deviation between R and Stata results.}

\item{id}{Name of the individual id variable (e.g. firm or farm; as string). Only applicable for fixed effect panel models.}

\item{time}{Name of the time id variable (e.g. year or month; as string). Only applicable for fixed effect panel models.}

\item{beta}{beta for which delta* should be estimated (default is beta = 0).}

\item{R2max}{Maximum R-square for which delta* should be estimated.}

\item{type}{Model type (either \emph{lm} or \emph{plm}; as string).}

\item{data}{Dataset.}
}
\value{
Returns tibble object, which includes delta* and various other information.
}
\description{
Estimates delta*, i.e., the degree of selection on unobservables relative to observables (with respect to the treatment variable) that would be necessary to eliminate the result (following Oster 2019). The code is based on the psacalc command in Stata.
}
\details{
Estimates delta*, i.e., the degree of selection on unobservables relative to observables (with respect to the treatment variable) that would be necessary to eliminate the result (following Oster 2019). The function supports linear cross-sectional (see \emph{lm} objects in R) and fixed effect panel (see \emph{plm} objects in R) models.
}
\examples{
# load data, e.g. the in-build mtcars dataset
data("mtcars")
data_oster <- mtcars

# preview of data
head(data_oster)

# load robomit
require(robomit)

# estimate delta*
o_delta(y = "mpg",           # dependent variable
        x = "wt",            # independent treatment variable
        con = "hp + qsec",   # related control variables
        beta = 0,            # beta
        R2max = 0.9,         # maximum R-square
        type = "lm",         # model type
        data = data_oster)   # dataset
}
\references{
Oster, E. (2019). Unobservable Selection and Coefficient Stability: Theory and Evidence. Journal of Business & Economic Statistics, 37, 187-204.
}
