% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LMS.R, R/Opal.R
\name{getLMSResourceURL}
\alias{getLMSResourceURL}
\alias{getLMSResourceURL,missing-method}
\alias{getLMSResourceURL,Opal-method}
\title{Create an URL using the resource's display name on LMS}
\usage{
getLMSResourceURL(object, display_name)

\S4method{getLMSResourceURL}{missing}(object, display_name)

\S4method{getLMSResourceURL}{Opal}(object, display_name)
}
\arguments{
\item{object}{An S4 object of class \link{Opal} that represents a connection to the LMS.}

\item{display_name}{A length one character vector to entitle file in OPAL;
it takes file name without extension by default; optional.}
}
\value{
A string value of URL.
}
\description{
This method creates an URL for user's resource by its name on Learning Management System (LMS).
If no LMS connection object is provided, it attempts to guess the connection using default settings (e.g., environment variables).
If the connection cannot be established, an error is thrown.
}
