% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LMS.R, R/Opal.R
\name{getLMSResourcesByName}
\alias{getLMSResourcesByName}
\alias{getLMSResourcesByName,missing-method}
\alias{getLMSResourcesByName,Opal-method}
\title{Get select records about user resources by name.}
\usage{
getLMSResourcesByName(object, ...)

\S4method{getLMSResourcesByName}{missing}(object, display_name, rtype = NULL)

\S4method{getLMSResourcesByName}{Opal}(object, display_name, rtype = NULL)
}
\arguments{
\item{object}{An S4 object of class \link{Opal} that represents a connection to
the LMS.}

\item{...}{Additional arguments to be passed to the method, if applicable.}

\item{display_name}{A string value withe the name of resource.}

\item{rtype}{A string value with the type of resource. Possible values:
"FileResource.TEST", "FileResource.QUESTION", or "FileResource.SURVEY".}
}
\value{
A dataframe with attributes of user's resources.
}
\description{
This method retrieves data about a user's resource by its name on Learning Management System (LMS).
If no LMS connection object is provided, it attempts to guess the connection using default settings (e.g., environment variables).
If the connection cannot be established, an error is thrown.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
df <- getLMSResourcesByName("task_name")
\dontshow{\}) # examplesIf}
}
