% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qti_task.R
\name{verify_qti}
\alias{verify_qti}
\title{Verify QTI XML against XSD Schema QTI v2.1}
\usage{
verify_qti(doc, extended_scheme = FALSE)
}
\arguments{
\item{doc}{A character string representing the path to the XML file or an
\code{xml2} document object.}

\item{extended_scheme}{A boolean value that controls the version of the XSD
schema used for validation. If \code{TRUE}, the extended version is used,
allowing additional tags in the XML (e.g., \code{details}). Default is \code{FALSE}.}
}
\value{
A logical value indicating whether the XML document is valid
according to the schema. If invalid, returns an object detailing the
validation errors.
}
\description{
This function validates a QTI XML document against the IMS QTI v2.1.2 XSD
schema.
}
\examples{
\dontrun{
# Validate an XML file
result <- verify_qti("path/to/your/qti.xml")
}
}
