% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rrscale.R
\name{rrscale}
\alias{rrscale}
\title{Re-scale a data matrix}
\usage{
rrscale(
  Y,
  trans_list = list(box_cox_negative = box_cox_negative, asinh = asinh),
  lims_list = list(box_cox_negative = c(-100, 100), asinh = list(0, 100)),
  opt_control = NULL,
  opt_method = "DEoptim",
  z = 4,
  q = 0.001,
  verbose = FALSE,
  log_dir = ".rrscale/",
  zeros = FALSE,
  opts = FALSE,
  seed = NULL
)
}
\arguments{
\item{Y}{Data matrix, data.frame, or list of vectors, to be transformed.}

\item{trans_list}{List of transformations to be considered. See function list_transformations. Each element of the list should be a list containing the transformation function as the first element and the derivative of the transformation function as the second argument. The first argument of each function should be the data, the second the transformation parameter.}

\item{lims_list}{List of optimization limits for each transformation from trans_list. This should be a list the same length as \code{trans_list}. Each element of the list is a two-element vector that sets the optimization limits for the parameter of each transformation family.}

\item{opt_control}{Optional optimization controlling parameters for DEoptim control argument. See the DEoptim package for details.}

\item{opt_method}{Which optimization method to use. Defaults to DEoptim. Other choice is nloptr.}

\item{z}{The O-step cutoff value. Points are removed if their robust z-score is above z in magnitude.}

\item{q}{The Z-step winsorizing quantile cutoff. The quantile at which to winsorize the data when calculating the robust z-scores.}

\item{verbose}{a boolean, if TRUE then save optimization output in log_dir.}

\item{log_dir}{directory for verbose output. Defaults to ".rrscale/"}

\item{zeros}{How to deal with zeros in the data set. If set to FALSE the algorithm will fail if it encounters a zero. If set to a number or 'NA' then the zeros are replaced by this number or 'NA'.}

\item{opts}{Boolean determining if optimization output is returned. Defaults to FALSE.}

\item{seed}{Sets the seed before running any other analyses.}
}
\value{
A list of output:
\itemize{
\item{opts:} the optimization output for all transformation families and all columns
\item{pars:} the optimal parameters for each column for the optimal family
\item{par_hat:} the estimated optimal paramter
\item{NT:} the original data
\item{RR:} the robust-rescaled data
\item{G:} gaussianized data
\item{Z:} robust z-transformed data
\item{O:} data with outliers removed
\item{rr_fn:} a function to apply the estimated RR transformation to new data. Takes arguments
\itemize{
\item {Y:} the data,
\item {z:} the z-score cutoff (defaults to 4),
\item {q:} the winsorizing quantile cutoff (defaults to 0.001),
\item {lambda:} the transformation parameter to use (defaults to the estimated one),
\item {T:} the transformation function family (defaults to the optimal estimated family),
\item {mu:} the mean to be used in the robust z-score step (re-estimates if NULL)
\item {sigma:} the s.d. to be used in the robust z-score step (re-estimates if NULL)
}
\item{T:} the optimal family
\item{T_deriv:} the derivative of the optimal family
\item{T_name:} name of the optimal family
\item{alg_control:} the parameters passed to the algorithm
}
}
\description{
This transformation is three steps (1) Gaussianize the data, (2) z-score Transform the data, and (3) remove extreme outliers from the data. The sequence of these transformations helps focus further analyses on consequential variance in the data rather than having it be focused on variation resulting from the feature's measurement scale or outliers.
}
\examples{
Y <- rlnorm(10)\%*\%t(rlnorm(10))
rr.out <- rrscale(Y)
Yt <- rr.out$RR
}
