% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tt_pos_and_access.R
\name{tt_row_path_exists}
\alias{tt_row_path_exists}
\alias{tt_normalize_row_path}
\alias{pathing}
\title{Pathing}
\usage{
tt_row_path_exists(obj, path, tt_type = c("any", "row", "table", "elemtable"))

tt_normalize_row_path(
  obj,
  path,
  .prev_path = character(),
  tt_type = c("any", "row", "table", "elemtable")
)
}
\arguments{
\item{obj}{(\code{ANY})\cr the object for the accessor to access or modify.}

\item{path}{(\code{character})\cr a vector path for a position within the structure of a \code{TableTree}. Each element
represents a subsequent choice amongst the children of the previous choice.}

\item{tt_type}{(\code{character(1)})\cr One of "any", "row", "table", "elemtable";
when testing existence or resolving a path with "*" wildcards,
this indicates a restriction on \emph{the final element the path resolves to}.
E.g., for "table", possible paths which match the structure of the
wild-card path but resolve to an individual row will not be considered matching.
The value "elemtable" indicates an Elementary table, i.e., one representing a
single variable within an \code{analyze} call.}

\item{.prev_path}{(\code{character})\cr Internal implementation detail.
Do not set manually.}
}
\value{
For \code{tt_row_path_exists}: \code{TRUE} if the path resolves to at least one
substructure (subtable or row) that satisfies \code{tt_type}, or if the
path is length 0; \code{FALSE} otherwise

for \code{tt_normalize_row_path}: a list of 0 or more fully
specified paths which exist in the row structure of \code{obj} that
match the original wildcard path, and which lead to an element
of type \code{tt_type} (if specified other than \verb{"any")}.
}
\description{
for \code{tt_row_path_exists}, tests whether a single path (potentially
including \code{"*"} wildcards) resolves to at least one element satisfying
\code{tt_type} (if specified).

Given a path with at least one wildcard (\code{"*"}) in it,
\code{tt_normalize_path} walks the tree and generates the complete
set of fully specified (ie no wildcards) paths which exist in
the row structure of \code{obj}
}
\details{
Pathing is a method of using known structure within a table
to specify elements within it in a self-describing, semantically
meaningful way.

A Path consists of a character vector of one or more elements which
will be used to descend the tree structure of a table's row or column space.

Existing paths will match the layout used to make the table in the form of
split, split-value pairs corresponding to facets generated by \verb{split_rows_by*}
and, elementary subtables generated by \code{analyze}, and rows generated by the
afun used. Groups summaries generated by \code{summarize_row_groups} are represented
by the 'content table' attached to a subtable representing a facet generated
by a \code{split_rows_by} instruction, and are addressed via \verb{@content} instead
of their name.

For example, given the code
\preformatted{
lyt <- basic_table() |>
  split_rows_by("ARM") |>
  split_rows_by("RACE") |>
  summarize_row_groups() |>
  analyze("SEX") |>
  analyze("AGE", nested = FALSE)

tbl <- build_table(lyt, DM)
}

We know that there will be two top-level subtables, one representing
(and generated via) the split on the \code{ARM} variable, and one
generated from the non-nested analyze on \code{AGE}. These can be be
'pathed to' at \code{"ARM"} and \code{"AGE"}, respectively. Furthermore
each value for \code{ARM} can be pathed to via, e.g.,  \code{c("ARM", "A: Drug X")}
or more generally using the pathing wildcard \code{"*"} at \code{c("ARM", "*")}.

A particular \code{SEX} analysis subtable, then, would be pathed to via the
(row) path \code{c("ARM", "*", "RACE", "*", "SEX")}, e.g.
\code{c("ARM", "B: Placebo", "RACE", "ASIAN", "SEX")}. The group-summary for
Asians within the placebo group would be pathed to via
\code{c("ARM", "B: Placebo", "RACE", "ASIAN", "@content")} for the table, and
\code{c("ARM", "B: Placebo", "RACE", "ASIAN", "@content", "ASIAN")} for the
row.
}
\note{
some pathing-based functionality supports the "*" wildcard (typically
'setters'/functionality which alters a table and returns it) while some
does not (typically 'getters' which retrieve a subtable/row from a table
or some attribute of that subtable/row).

The \code{"*"} wildcard will never act as \code{"@content"} to step into
a subtable's content table; that must be specified in the path, via
e.g., \code{c("*", "*", "@content")} instead of \code{c("*", "*", "*")}.
}
\examples{
lyt <- basic_table() |>
  split_rows_by("ARM") |>
  split_rows_by("STRATA1") |>
  analyze("SEX") |>
  analyze("SEX", nested = FALSE)
tbl <- build_table(lyt, DM)
tt_row_path_exists(tbl, c("root", "ARM", "*", "*", "*", "SEX")) # TRUE
tt_row_path_exists(tbl, c("ARM", "*", "*", "*", "SEX")) # TRUE
tt_row_path_exists(tbl, c("ARM", "*", "*", "SEX")) # FALSE
tt_row_path_exists(tbl, "FAKE") # FALSE
tt_row_path_exists(tbl, c("ARM", "*", "STRATA1", "*", "SEX")) # TRUE
tt_row_path_exists(tbl, c("ARM", "*", "STRATA", "*", "SEX")) # FALSE
tt_row_path_exists(tbl, "SEX") # TRUE
tt_row_path_exists(tbl, "SEX", tt_type = "table") # TRUE
tt_row_path_exists(tbl, "SEX", tt_type = "elemtable") # TRUE
tt_row_path_exists(tbl, "SEX", tt_type = "row") # FALSE
tt_row_path_exists(tbl, c("SEX", "*")) # TRUE
tt_normalize_row_path(tbl, c("root", "ARM", "*", "*", "*", "SEX"))
tt_normalize_row_path(tbl, "SEX", tt_type = "row") # empty list
}
