% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discretize_gamma.R
\name{discretize_gamma}
\alias{discretize_gamma}
\title{Compute the discretized density function for gamma distribution}
\usage{
discretize_gamma(x, shape = 2.5, scale = 2.5, rate = 1/scale)
}
\arguments{
\item{x}{locations (times) where cases are observed. Must be nonnegative.}

\item{shape, scale}{shape and scale parameters.  Must be positive,
    \code{scale} strictly.}

\item{rate}{an alternative way to specify the scale.}
}
\value{
probability mass of the discretized gamma distribution
}
\description{
The serial interval distribution expresses the probability of the
symptom onset of a secondary infection occurred a given number of days after
the primary infection. The serial interval distribution is commonly
represented by a discretized Gamma distribution in literature, parametrized
by the shape and scale parameters.
}
\examples{
discretize_gamma(1:30, shape = 1, scale = 1)
}
