% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lc.R
\name{lc}
\alias{lc}
\title{Lorenz and Generalized Lorenz curves}
\usage{
lc(dataset, ipuc = "ipuc", hhcsw = "DB090", hhsize = "HX040",
  samplesize = 10, generalized = FALSE, plot = FALSE)
}
\arguments{
\item{dataset}{a data.frame containing the variables.}

\item{ipuc}{a character string indicating the variable name of the income per unit of consumption. Default is "ipuc".}

\item{hhcsw}{a character string indicating the variable name of the household cross-sectional weight. Default is "DB090".}

\item{hhsize}{a character string indicating the variable name of the household size. Default is "HX040".}

\item{samplesize}{an integer which specifies the number of (equally spaced) percentiles to be used in the estimation of the Lorenz (or the Generalized Lorenz) ordinates. The default value is 10. If samplesize is set to ''complete'', ordinates are computed in each value along the whole distribution.}

\item{generalized}{logical; if TRUE the Generalized Lorenz curve ordinates will be estimated.}

\item{plot}{logical; if TRUE plots the Lorenz or Generalized Lorenz curve.}
}
\value{
A data.frame with the following components:
\itemize{
\item x.lg, vector of cumulated proportion of population.
\item y.lg, vector with values of the Lorenz or the Generalized Lorenz curves ordinates.
}
}
\description{
Estimates the Lorenz and the Generalized Lorenz curves ordinates.
}
\details{
Lorenz and Generalized Lorenz curves ordinates are computed using the equivalised disposable income. The equivalence scales employed are the modified OECD scale and the parametric scale of Buhmann et al. (1988) (see setupDataset).
}
\examples{
data(eusilc2)
ATdataset <- setupDataset(eusilc2, country = "AT")
lc.curve <- lc(ATdataset)
str(lc.curve)

}
\references{
B C Arnold (1987) Majorization and the Lorenz order: A brief introduction, Lecture Notes in Statistics, 43, Springer-Verlag.

B. Buhmann et al. (1988) Equivalence scales, well-being, inequality and poverty: sensitivity estimates across ten countries using the Luxembourg Income Study (LIS) database, Review of Income and Wealth, 34, 115--142.
}
\seealso{
setupDataset
}
\author{
A. Berihuete, C.D. Ramos and M.A. Sordo
}
