% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testGL.R
\name{testGL}
\alias{testGL}
\title{Test for Lorenz and Generalized Lorenz dominance}
\usage{
testGL(dataset1, dataset2, ipuc = "ipuc", hhcsw = "DB090",
  hhsize = "HX040", generalized = TRUE, samplesize = 10, alpha = 0.05)
}
\arguments{
\item{dataset1}{a data.frame containing the variables.}

\item{dataset2}{a data.frame containing the variables.}

\item{ipuc}{a character string indicating the variable name of the income per unit of consumption. Default is "ipuc".}

\item{hhcsw}{a character string indicating the variable name of the household cross-sectional weight. Default is "DB090".}

\item{hhsize}{a character string indicating the variable name of the household size. Default is "HX040".}

\item{generalized}{logical; if FALSE the test will be applied to compare two Lorenz curves. Otherwise Generalized Lorenz curves will be compared.}

\item{samplesize}{an integer which represents the number of Lorenz (Generalized Lorenz) curve ordinates to be estimated for comparison. The default is 10.}

\item{alpha}{a scalar indicating the significance level. Default is 0.05.}
}
\value{
A list with the following components:

\itemize{
\item Tvalue the value of the test-statistic
\item p.value simulated p-value of the test-statistic Tvalue (Wolak, 1989). It is calculated only when the Tvalue falls into an inconclusive region.
\item decision if the Tvalue is less than the lower-bound of the critical value at the \eqn{alpha} significance level the decision is "Do not reject null hypothesis". If the Tvalue is greater than the upper-bound of the critical value at the \eqn{alpha} significance level the decision is "Reject null hypothesis". Lower and upper-bounds critical values are obtained from Kodde and Palm (1986). If Tvalue falls into an inconclusive region (between the lower- and upper-bounds) the p-value will be estimated following Wolak (1989).
}
}
\description{
Statistical test procedure given by Xu (1997) to study Generalized Lorenz dominance from sample Generalized Lorenz curve estimates.  Lorenz dominance from sample Lorenz curve estimates can also be studied (Beach and Kaliski, 1986).
}
\details{
The null hypothesis to be tested is that the  Lorenz (Generalized Lorenz) curve calculated from dataset1 dominates the one calculated from dataset2.
}
\examples{
data(eusilc2)
ATdataset1 <- setupDataset(eusilc2, country = "AT", region = "Burgenland")
ATdataset2 <- setupDataset(eusilc2, country = "AT", region = "Carinthia")
testGL(ATdataset1, ATdataset2, generalized = TRUE, samplesize = 10, alpha = 0.05)

}
\references{
C. M. Beach and R. Davidson (1983) Distribution-free statistical inference with Lorenz curves

C. M. Beach and S. F. Kaliski (1986) Curve inference with sample weights: and application to the distribution of unemployment experience, Journal of the Royal Statistical Society. Series C (Applied Statistics), Vol. 35, No. 1, 38--45.

D.A. Kodde and F.C. Palm (1986) Wald criteria for jointly testing equality and inequality restrictions, Econometrica, 50, 1243--1248.

F.A. Wolak (1989), Testing inequality constrains in linear econometric models, Journal of Econometrics, 41, 205--235.

K. Xu (1997) Asymptotically distribution-free statistical test for generalized Lorenz curves: An alternative approach, Journal of Income Distribution, 7(1), 45--62.
}
\seealso{
OmegaGL, setupDataset
}
\author{
A. Berihuete, C.D. Ramos and M.A. Sordo
}
