% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runExamplesWrapper.R
\name{RunExamples}
\alias{RunExamples}
\title{RunExamples}
\usage{
RunExamples(
  pack,
  run_donttest = TRUE,
  run_dontrun = TRUE,
  out = sprintf("\%s/\%s", tempdir(), "runExamplesOut.txt"),
  verbose = FALSE
)
}
\arguments{
\item{pack}{character string containing the path name of the package directory}

\item{run_donttest}{parameter to be passed to run_examples()}

\item{run_dontrun}{parameter to be passed to run_examples()}

\item{out}{character string containing the path name of the run_examples() results output file}

\item{verbose}{Boolean if TRUE generate some diagnostic information}
}
\value{
returns a character vector specifying each function example as either "GOOD", "BAD", or "MIA"
}
\description{
driver to automate run_examples() and retrieve the test results for each example
}
\examples{
\dontrun{
# replace dir and pack with your own versions!!
# run this example within the RStudio Console for the package 'pack'
dir1<-"~/personal/hearts/hearts_card_game_bayesian_inference/packages/"
dir2<-"inference_packages/inference_packages/"
dir<-sprintf("\%s/\%s",dir1,dir2)
pack<-sprintf("\%s/\%s",dir,"cardUtils")
v<-RunExamples(pack,verbose=FALSE)
}

}
