% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfWishart.R
\name{dfWishart}
\alias{dfWishart}
\title{This uses simulations to match the rse}
\usage{
dfWishart(omega, n, rse, upper, totN = 1000, diag = TRUE, seed = 1234)
}
\arguments{
\item{omega}{represents the matrix for simulation}

\item{n}{This represents the number of subjects/samples this comes
from (used to calculate rse).  When present it assumes the rse=
sqrt(2)/sqrt(n)}

\item{rse}{This is the rse that we try to match, if not specified,
it is derived from \code{n}}

\item{upper}{The upper boundary for root finding in terms of
degrees of freedom.  If not specified, it is n*200}

\item{totN}{This represents the total number of simulated inverse
wishart deviates}

\item{diag}{When \code{TRUE}, represents the rse to match is the
diagonals, otherwise it is the total matrix.}

\item{seed}{to make the simulation reproducible, this represents
the seed that is used for simulating the inverse Wishart
distribution}
}
\value{
output from \code{uniroot()} to find the right estimate
}
\description{
This uses simulations to match the rse
}
\examples{

dfWishart(lotri::lotri(a+b~c(1, 0.5, 1)), 100)

}
\author{
Matthew L. Fidler
}
