% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/llik.R
\name{llikWeibull}
\alias{llikWeibull}
\title{log likelihood and derivatives for Weibull distribution}
\usage{
llikWeibull(x, shape, scale, full = FALSE)
}
\arguments{
\item{x}{variable distributed by a Weibull distribution}

\item{shape, scale}{shape and scale parameters, the latter defaulting to 1.}

\item{full}{Add the data frame showing x, mean, sd as well as the
fx and derivatives}
}
\value{
data frame with \code{fx} for the log pdf value of with \code{dProb}
that has the derivatives with respect to the \code{prob} parameters at
the observation time-point
}
\description{
log likelihood and derivatives for Weibull distribution
}
\details{
In an \code{rxode2()} model, you can use \code{llikWeibull()} but you have to
use the x and rate arguments.  You can also get the derivative of \code{shape} or \code{scale} with
\code{llikWeibullDshape()} and \code{llikWeibullDscale()}.
}
\examples{
\donttest{
llikWeibull(1, 1, 10)

# rxode2 can use this too:

et  <- et(seq(0.001, 1, length.out=10))
et$shape <- 1
et$scale <- 10
 
model <- function() {
  model({
    fx <- llikWeibull(time, shape, scale)
    dShape<- llikWeibullDshape(time, shape, scale)
    dScale <- llikWeibullDscale(time, shape, scale)
  })
}

rxSolve(model, et)
}
}
\author{
Matthew L. Fidler
}
