% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ParamMHMMR.R
\docType{class}
\name{ParamMHMMR-class}
\alias{ParamMHMMR-class}
\alias{ParamMHMMR}
\title{A Reference Class which contains parameters of a MHMMR model.}
\description{
ParamMHMMR contains all the parameters of a MHMMR model. The parameters are
calculated by the initialization Method and then updated by the Method
implementing the M-Step of the EM algorithm.
}
\section{Fields}{

\describe{
\item{\code{mData}}{\link{MData} object representing the sample (covariates/inputs
\code{X} and observed multivariate responses/outputs \code{Y}).}

\item{\code{K}}{The number of regimes (MHMMR components).}

\item{\code{p}}{The order of the polynomial regression.}

\item{\code{variance_type}}{Character indicating if the model is homoskedastic
(\code{variance_type = "homoskedastic"}) or heteroskedastic (\code{variance_type = "heteroskedastic"}). By default the model is heteroskedastic.}

\item{\code{prior}}{The prior probabilities of the Markov chain. \code{prior} is a row
matrix of dimension \eqn{(1, K)}.}

\item{\code{trans_mat}}{The transition matrix of the Markov chain. \code{trans_mat} is a
matrix of dimension \eqn{(K, K)}.}

\item{\code{mask}}{Mask applied to the transition matrices \code{trans_mat}. By default,
a mask of order one is applied.}

\item{\code{beta}}{Parameters of the polynomial regressions. \eqn{\boldsymbol{\beta}
  = (\boldsymbol{\beta}_{1},\dots,\boldsymbol{\beta}_{K})}{\beta =
  (\beta_{1},\dots,\beta_{K})} is an array of dimension \eqn{(p + 1, d, K)},
with \code{p} the order of the polynomial regression. \code{p} is fixed to 3 by
default.}

\item{\code{sigma2}}{The variances for the \code{K} regimes. If MRHLP model is
heteroskedastic (\code{variance_type = "heteroskedastic"}) then \code{sigma2} is an
array of size \eqn{(d, d, K)} (otherwise MRHLP model is homoskedastic
(\code{variance_type = "homoskedastic"}) and \code{sigma2} is a matrix of size
\eqn{(d, d)}).}

\item{\code{nu}}{The degree of freedom of the MHMMR model representing the
complexity of the model.}

\item{\code{phi}}{A list giving the regression design matrices for the polynomial
and the logistic regressions.}
}}

\section{Methods}{

\describe{
\item{\code{initParam(try_algo = 1)}}{Method to initialize parameters \code{prior}, \code{trans_mat},
      \code{beta} and \code{sigma2}.

      If \code{try_algo = 1} then \code{beta} and \code{sigma2} are
      initialized by segmenting  the time series \code{Y} uniformly into
      \code{K} contiguous segments. Otherwise, \code{beta} and
      \code{sigma2} are initialized by segmenting randomly the time series
      \code{Y} into \code{K} segments.}

\item{\code{MStep(statMHMMR)}}{Method which implements the M-step of the EM algorithm to learn the
parameters of the MHMMR model based on statistics provided by the object
\code{statMHMMR} of class \link{StatMHMMR} (which contains the
E-step).}
}}

