% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ParamMRHLP.R
\docType{class}
\name{ParamMRHLP-class}
\alias{ParamMRHLP-class}
\alias{ParamMRHLP}
\title{A Reference Class which contains the parameters of a MRHLP model.}
\description{
ParamMRHLP contains all the parameters of a MRHLP model. The parameters are
calculated by the initialization Method and then updated by the Method
implementing the M-Step of the EM algorithm.
}
\section{Fields}{

\describe{
\item{\code{mData}}{\link{MData} object representing the sample (covariates/inputs
\code{X} and observed responses/outputs \code{Y}).}

\item{\code{K}}{The number of regimes (MRHLP components).}

\item{\code{p}}{The order of the polynomial regression.}

\item{\code{q}}{The dimension of the logistic regression. For the purpose of
segmentation, it must be set to 1.}

\item{\code{variance_type}}{Character indicating if the model is homoskedastic
(\code{variance_type = "homoskedastic"}) or heteroskedastic (\code{variance_type = "heteroskedastic"}). By default the model is heteroskedastic.}

\item{\code{W}}{Parameters of the logistic process. \eqn{\boldsymbol{W} =
  (\boldsymbol{w}_{1},\dots,\boldsymbol{w}_{K-1})}{W = (w_{1},\dots,w_{K-1})}
is a matrix of dimension \eqn{(q + 1, K - 1)}, with \code{q} the order of the
logistic regression. \code{q} is fixed to 1 by default.}

\item{\code{beta}}{Parameters of the polynomial regressions. \eqn{\boldsymbol{\beta}
  = (\boldsymbol{\beta}_{1},\dots,\boldsymbol{\beta}_{K})}{\beta =
  (\beta_{1},\dots,\beta_{K})} is an array of dimension \eqn{(p + 1, d, K)},
with \code{p} the order of the polynomial regression. \code{p} is fixed to 3 by
default.}

\item{\code{sigma2}}{The variances for the \code{K} regimes. If MRHLP model is
heteroskedastic (\code{variance_type = "heteroskedastic"}) then \code{sigma2} is an
array of size \eqn{(d, d, K)} (otherwise MRHLP model is homoskedastic
(\code{variance_type = "homoskedastic"}) and \code{sigma2} is a matrix of size
\eqn{(d, d)}).}

\item{\code{nu}}{The degree of freedom of the MRHLP model representing the
complexity of the model.}

\item{\code{phi}}{A list giving the regression design matrices for the polynomial
and the logistic regressions.}
}}

\section{Methods}{

\describe{
\item{\code{initParam(try_algo = 1)}}{Method to initialize parameters \code{W}, \code{beta} and
      \code{sigma2}.

      If \code{try_algo = 1} then \code{beta} and \code{sigma2} are
      initialized by segmenting  the time series \code{Y} uniformly into
      \code{K} contiguous segments. Otherwise, \code{W}, \code{beta} and
      \code{sigma2} are initialized by segmenting randomly the time series
      \code{Y} into \code{K} segments.}

\item{\code{MStep(statMRHLP, verbose_IRLS)}}{Method which implements the M-step of the EM algorithm to learn the
parameters of the MRHLP model based on statistics provided by the object
\code{statMRHLP} of class \link{StatMRHLP} (which contains the
E-step).}
}}

