% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sar_weibull3.R
\name{sar_weibull3}
\alias{sar_weibull3}
\title{Fit the Cumulative Weibull 3 par. model}
\usage{
sar_weibull3(data, start = NULL, grid_start = 'partial',
  grid_n = NULL, normaTest = 'none',
  homoTest = 'none', homoCor = 'spearman', verb = TRUE)
}
\arguments{
\item{data}{A dataset in the form of a dataframe with two columns: 
the first with island/site areas, and the second with the species richness
of each island/site.}

\item{start}{NULL or custom parameter start values for the optimisation algorithm.}

\item{grid_start}{Should a grid search procedure be implemented to test multiple starting parameter values. Can be one of 'none', 'partial' or 'exhaustive' The default is set to 'partial'.}

\item{grid_n}{If \code{grid_start = exhaustive}, the number of points sampled in the starting parameter space.}

\item{normaTest}{The test used to test the normality of the residuals of the
  model. Can be any of 'lillie' (Lilliefors test
, 'shapiro' (Shapiro-Wilk test of normality), 'kolmo'
  (Kolmogorov-Smirnov test), or 'none' (no residuals normality test is undertaken; the default).}

\item{homoTest}{The test used to check for homogeneity of the residuals of
the model. Can be any of 'cor.fitted' (a correlation of the residuals with
the model fitted values), 'cor.area' (a correlation of the
residuals with the area values), or 'none' (no residuals homogeneity test is undertaken; the default).}

\item{homoCor}{The correlation test to be used when \code{homoTest !='none'}. Can be any of 'spearman'
(the default), 'pearson', or 'kendall'.}

\item{verb}{Whether or not to print certain warnings (default = TRUE)}
}
\value{
A list of class 'sars' with the following components: 
  \itemize{
    \item \strong{par}  The model parameters
    \item \strong{value}  Residual sum of squares
    \item \strong{counts}   The number of iterations for the convergence of the fitting algorithm
    \item \strong{convergence}  Numeric code returned from optim indicating model convergence (0 = converged)
    \item \strong{message}  Any message from the model fit algorithm
    \item \strong{hessian}  A symmetric matrix giving an estimate of the Hessian at the solution found
    \item \strong{verge}  Logical code indicating that optim model convergence value is zero
    \item \strong{startValues}  The start values for the model parameters used in the optimisation
    \item \strong{data}  Observed data
    \item \strong{model}  A list of model information (e.g. the model name and formula)
    \item \strong{calculated}   The fitted values of the model
    \item \strong{residuals}  The model residuals
    \item \strong{AIC}  The AIC value of the model
    \item \strong{AICc}  The AICc value of the model
    \item \strong{BIC}  The BIC value of the model
    \item \strong{R2}  The R2 value of the model
    \item \strong{R2a}  The adjusted R2 value of the model
    \item \strong{sigConf}  The model coefficients table
    \item \strong{normaTest}  The results of the residuals normality test
    \item \strong{homoTest}  The results of the residuals homogeneity test
    \item \strong{observed_shape}  The observed shape of the model fit
    \item \strong{asymptote}  A logical value indicating whether the observed fit is asymptotic
    \item \strong{neg_check}  A logical value indicating whether negative fitted values have been returned}
  The \code{\link{summary.sars}} function returns a more useful summary of
  the model fit results, and the \code{\link{plot.sars}} plots the model fit.
}
\description{
Fit the Cumulative Weibull 3 par. model to SAR data.
}
\details{
The model is fitted using non-linear regression. The model parameters are estimated
  by minimizing the residual sum of squares with an unconstrained Nelder-Mead optimization algorithm
  and the \code{\link{optim}} function. To avoid numerical problems and speed up the convergence process,
  the starting values used to run the optimization algorithm are carefully chosen. However, if this does
not work, custom values can be provided (using the \code{start} argument), or a more comprehensive search
  can be undertaken using the \code{grid_start} argument. See the vignette for more information.
  The fitting process also determines the observed shape of the model fit,
  and whether or not the observed fit is asymptotic (see Triantis et al. 2012 for further details).
  Model validation can be undertaken by assessing the normality (\code{normaTest}) and homogeneity (\code{homoTest})
  of the residuals and a warning is provided in \code{\link{summary.sars}} if either test is chosen and fails.
  A selection of information criteria (e.g. AIC, BIC) are returned and can be used to compare models
  (see also \code{\link{sar_average}}).
  
  As grid_start has a random component, when \code{grid_start != 'none'} in your model fitting, you can
   get slightly different results each time you fit a model
  
   The parameter confidence intervals returned in sigConf are just simple confidence intervals, calculated as 2 * standard error.
}
\examples{
data(galap)
fit <- sar_weibull3(galap)
summary(fit)
plot(fit)
}
\references{
Triantis, K.A., Guilhaumon, F. & Whittaker, R.J. (2012) The island species-area
  relationship: biology and statistics. Journal of Biogeography, 39, 215-231.
}
