% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{closed_labels}
\alias{closed_labels}
\title{Human-readable labels for closed breaks}
\usage{
closed_labels(x, min_is_zero = FALSE)
}
\arguments{
\item{x}{Vector of breaks for which to produce labels.
Typically, this is the output of \code{closed_breaks_log2}.}

\item{min_is_zero}{Should the smallest break be
displayed as zero (TRUE) or as the actual value (FALSE). Default: FALSE}
}
\value{
Character vector with labels, used by \code{feat} function.
}
\description{
Complements the closed_breaks_log2 function.
}
\details{
This is a helper for the \code{feat} function.
\code{feat} replaces numeric zeros with the next-smallest expression value
to avoid taking the logarithm of zero. \code{min_is_zero} can be used to
display the lowest break of the color scale as zero in these cases.
}
\examples{
 # human readable output:
 closed_labels(c(.001111,.122, 0.5, 10, 100, 1800))
}
\seealso{
\code{\link[scales]{label_scientific}}
 \code{\link[scales]{label_number_auto}}
}
