% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/breaks.R
\name{breaks_exp}
\alias{breaks_exp}
\title{Breaks for exponentially transformed data}
\usage{
breaks_exp(n = 5, ...)
}
\arguments{
\item{n}{Desired number of breaks. You may get slightly more or fewer
breaks that requested.}

\item{...}{other arguments passed on to \code{\link[labeling:extended]{labeling::extended()}}}
}
\value{
All \code{breaks_()} functions return a function for generating breaks. These
functions takes, as their first argument a vector of values that represent
the data range to provide breaks for. Some will optionally take a second
argument that allows you to specify the number of breaks to recieve.
}
\description{
This breaks function typically labels zero and the last \code{n - 1} integers of a
range if that range is large enough (currently: 3). For smaller ranges, it
uses \code{\link[=breaks_extended]{breaks_extended()}}.
}
\examples{
# Small range
demo_continuous(c(100, 102), transform = "exp", breaks = breaks_exp())
# Large range
demo_continuous(c(0, 100), transform = "exp", breaks = breaks_exp(n = 4))
}
