% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scatterbar.R
\name{scatterbar}
\alias{scatterbar}
\title{Create a scattered stacked bar chart plot}
\usage{
scatterbar(
  data,
  xy,
  size_x = NULL,
  size_y = NULL,
  padding_x = 0,
  padding_y = 0,
  show_legend = TRUE,
  legend_title = "Group",
  colors = NULL,
  verbose = TRUE
)
}
\arguments{
\item{data}{A data frame containing the proportions of different categories for each location. Each row represents a location, and each column (except the row names) represents a category.}

\item{xy}{A data frame containing the positional information for each location. This data frame includes the x and y coordinates for each location/spot (the respective row names).}

\item{size_x}{X-axis scaling factor (default is NULL). If not provided, it will be automatically calculated based on the data.}

\item{size_y}{Y-axis scaling factor (default is NULL). If not provided, it will be automatically calculated based on the data.}

\item{padding_x}{Padding for x-axis (default is 0).}

\item{padding_y}{Padding for y-axis (default is 0).}

\item{show_legend}{Boolean indicating whether to display the plot legend (default is TRUE).}

\item{legend_title}{Custom title for the legend (default is "Group").}

\item{colors}{Optional vector of colors to use for each category (default is NULL). If not provided, a default palette will be used.}

\item{verbose}{Boolean indicating whether to print the calculated scaling and padding values (default is TRUE).}
}
\value{
A ggplot object representing the scattered stacked bar chart plot.
}
\description{
This function creates a scatterbar plot using ggplot2, where the bars are stacked based on the different proportions of groups in each 2-D location/spot. A scatterbar plot is a combination of a scatter plot and a stacked bar chart, allowing for the visualization of proportional data across spatial coordinates.
The function allows for customized scaling factors and padding when creating the plot. If no scaling factors are specified, the function automatically determines the optimal scaling factors based on the data.
}
\examples{
data(mOB)
scatterbar(mOB$data, mOB$xy, padding_x = 0.3, padding_y = 0.3, legend_title = "Cell Types")

data(adult_mouse_brain_ffpe)
scatterbar(
adult_mouse_brain_ffpe$prop,
adult_mouse_brain_ffpe$pos,
size_x = 220,
size_y = 220,
legend_title = "Cell Types")


}
