% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{ConvolutionMatrix}
\alias{ConvolutionMatrix}
\title{Computes a matrix of Gaussian kernel convolution values given two vectors.}
\usage{
ConvolutionMatrix(x, s, h, threshold = 1e-10)
}
\arguments{
\item{x}{A numeric vector.}

\item{s}{A numeric vector.}

\item{h}{A positive bandwidth.}

\item{threshold}{Threshold value passed to SpectralShift.}
}
\value{
The matrix of convolution values.
}
\description{
If \code{x} and \code{s} are n- and m-vectors, respectively, returns the n-by-m matrix
of convolution values using Gaussian kernel with bandwidth \code{h}.  If \code{x} and
\code{s} are equal, the spectral shift is done to ensure the matrix is numerically
positive definite.
}
\keyword{internal}
