% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/napjack_helpers.R
\name{swapper}
\alias{swapper}
\title{Swap Cards Within a Row of a Card Matrix}
\usage{
swapper(cards_matrix, swap_in_row = NULL)
}
\arguments{
\item{cards_matrix}{A matrix of cards representing the current state of the game.}

\item{swap_in_row}{A vector of length 2 specifying the indices of the columns to
swap within a row. If \code{NULL} (default), no swapping is performed.}
}
\value{
The updated card matrix with the specified cards swapped within a row.
}
\description{
This function allows swapping of cards within a row of a card matrix. It takes a
card matrix and the indices of the columns to swap. The function modifies the
card matrix in-place and returns the updated matrix.
}
\details{
The function performs the following steps:
\enumerate{
\item Initializes a move history attribute if it doesn't exist.
\item Checks if \code{swap_in_row} is provided and has a length of 2.
\item Verifies that swapping within a phase has not been performed more than once.
\item Swaps the cards at the specified column indices within the first row of the matrix.
\item Updates the move history attribute.
\item Adds the "swapper" class to the card matrix.
}
}
\note{
The function modifies the card matrix in-place and returns the updated matrix.
}
\keyword{internal}
