% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{plot.scqe}
\alias{plot.scqe}
\title{Plot method for \code{scqe}}
\usage{
\method{plot}{scqe}(x, xlab, ylab, ...)
}
\arguments{
\item{x}{an object of class \code{\link{scqe}}}

\item{xlab}{Optional character label for x axis.}

\item{ylab}{Optional character label for y axis.}

\item{...}{Extra optional arguments}
}
\value{
Plot of estimates and confidence intervals.
}
\description{
The \code{print} method provides a plot of the estimates
and confidence intervals for the scqe estimates for the range of
values of delta provided by the user.
}
\examples{
set.seed(1234)
post <- c(rep(0,100), rep(1,100))
tx <- c(rep(0, 100), rbinom(n = 100, prob = 0.27, size = 1))
y <- rbinom(n = 200, prob = 0.1 + 0.02 * post - 0.05 * tx, size = 1)

# Two cohorts, full data
scqe.2cohort.full <- scqe(post = post, treatment = tx, outcome = y,
                          delta = seq(from = -0.1, to = 0.1, by = 0.05))
plot(scqe.2cohort.full)

}
