% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05_sdl_methods.R
\name{sdlrm-methods}
\alias{sdlrm-methods}
\alias{model.frame.sdlrm}
\alias{model.matrix.sdlrm}
\alias{coef.sdlrm}
\alias{vcov.sdlrm}
\alias{logLik.sdlrm}
\alias{AIC.sdlrm}
\title{Extract Information From a Modified Skew Discrete Laplace Regression Fit}
\usage{
\method{model.frame}{sdlrm}(formula, ...)

\method{model.matrix}{sdlrm}(object, parm = c("mean", "dispersion"), ...)

\method{coef}{sdlrm}(object, parm = c("mean", "dispersion", "full"), ...)

\method{vcov}{sdlrm}(object, parm = c("mean", "dispersion", "full"), ...)

\method{logLik}{sdlrm}(object, ...)

\method{AIC}{sdlrm}(object, ..., k = 2)
}
\arguments{
\item{formula}{a model \link{formula} or \link{terms} object or an \code{"sdlrm"} object.}

\item{...}{further arguments passed to or from other methods.}

\item{object}{an object of class \code{"sdlrm"}, a result of a call to \code{\link{sdlrm}}.}

\item{parm}{a character indicating which group of parameters is to be considered in the function.
The options are \code{"mean"} (default) to obtain the output in relation to the coefficients
associated with the mean, \code{"dispersion"} to obtain the output in relation to
the coefficients associated with the dispersion, or \code{"full"} (when applicable)
to consider all the parameters,}

\item{k}{numeric, the penalty per parameter to be used; the default
\code{k = 2} is the classical AIC.}
}
\value{
\itemize{
\item \code{model.frame} returns a \code{data.frame} containing the variables required
    by \code{formula} and any additional arguments provided via \code{...}.
\item \code{model.matrix} returns the design matrix used in the regression structure,
    as specified by the \code{parm} argument.
\item \code{coef} returns a numeric vector of estimated regression coefficients, based
    on the \code{parm} argument. If \code{parm = "full"}, it returns a list with the
    components \code{"mean"} and \code{"dispersion"}, each containing the corresponding
    coefficient estimates.
\item \code{vcov} returns the asymptotic covariance matrix of the regression coefficients,
    based on the \code{parm} argument.
\item \code{logLik} returns the log-likelihood value of the fitted model.
\item \code{AIC} returns a numeric value representing the Akaike Information Criterion
    (AIC), Bayesian Information Criterion, or another criterion, depending on \code{k}.
}
}
\description{
Additional methods for \code{"sdlrm"} objects.
}
\examples{
# Data set: pss (for description run ?pss)
barplot(table(pss$difference), xlab = "PSS index difference", ylab = "Frequency")
boxplot(pss$difference ~ pss$group, xlab = "Group", ylab = "PSS index difference")

# Fit a double model (mode = 1)
fit <- sdlrm(difference ~ group | group, data = pss, xi = 1)

# Coef
coef(fit)
coef(fit, parm = "dispersion")
coef(fit, parm = "full")

# vcov
vcov(fit)
vcov(fit, parm = "dispersion")
vcov(fit, parm = "full")

# Log-likelihood value
logLik(fit)

# AIC and BIC
AIC(fit)
AIC(fit, k = log(fit$nobs))

# Model matrices
model.matrix(fit)
model.matrix(fit, "dispersion")
}
\author{
Rodrigo M. R. de Medeiros <\email{rodrigo.matheus@ufrn.br}>
}
